/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.NonArrowProjectile;
import net.soulsweaponry.entitydata.posture.PostureData;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class SilverBulletEntity
extends NonArrowProjectile
implements GeoEntity {
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private int postureLoss;

    public SilverBulletEntity(EntityType<? extends SilverBulletEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SilverBulletEntity(Level world, LivingEntity owner) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.SILVER_BULLET_ENTITY_TYPE.get()), owner, world);
    }

    public SilverBulletEntity(EntityType<? extends SilverBulletEntity> entityType, Level world, LivingEntity owner) {
        super(entityType, owner, world);
    }

    public void m_8119_() {
        Vec3 vec3d;
        super.m_8119_();
        if (!this.f_36703_) {
            vec3d = this.m_20184_();
            double e = vec3d.f_82479_;
            double f = vec3d.f_82480_;
            double g = vec3d.f_82481_;
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + e * (double)i / 4.0, this.m_20186_() + f * (double)i / 4.0, this.m_20189_() + g * (double)i / 4.0, -e * 0.2, (-f + 0.2) * 0.2, -g * 0.2);
            }
        }
        vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_, vec3d.f_82480_ + (double)0.045f, vec3d.f_82481_);
        if (this.f_19797_ > this.getMaxAge()) {
            this.m_146870_();
        }
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12442_;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_146870_();
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity;
        if (ConfigConstructor.can_projectiles_apply_posture_loss && (entity = entityHitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            int posture = this.getPostureLoss();
            if (target instanceof Player) {
                posture = Mth.m_14143_((float)((float)posture * ConfigConstructor.silver_bullet_posture_loss_on_player_modifier));
            }
            PostureData.addPosture(target, posture);
            if (target.m_21222_()) {
                this.m_36781_(this.m_36789_() + (double)ConfigConstructor.silver_bullet_undead_bonus_damage / this.m_20184_().m_82553_());
            }
        }
        super.m_5790_(entityHitResult);
        this.m_146870_();
    }

    public int getMaxAge() {
        return 200;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected ItemStack m_7941_() {
        return ((Item)ItemRegistry.SILVER_BULLET.get()).m_7968_();
    }

    public void setPostureLoss(int postureLoss) {
        this.postureLoss = postureLoss;
    }

    public int getPostureLoss() {
        return this.postureLoss;
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("postureLoss")) {
            this.setPostureLoss(nbt.m_128451_("postureLoss"));
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("postureLoss", this.getPostureLoss());
    }
}

