/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.entity.projectile.NonArrowProjectile;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class MoonlightProjectile
extends NonArrowProjectile
implements GeoEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Integer> POINTS = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICK_PARTICLES = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MAX_AGE = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HUGE_EXPLOSION = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ROTATE_STATE = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ParticleOptions> EXPLOSION_PARTICLE = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private static final EntityDataAccessor<ParticleOptions> TRAIL_PARTICLE = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private static final EntityDataAccessor<Integer> APPLY_FIRE_TICKS = SynchedEntityData.m_135353_(MoonlightProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private ItemStack stackShotFrom;

    public MoonlightProjectile(EntityType<? extends AbstractArrow> entityType, Level world) {
        super(entityType, world);
    }

    public MoonlightProjectile(EntityType<? extends AbstractArrow> type, Level world, LivingEntity owner) {
        super(type, owner, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(POINTS, (Object)75);
        this.f_19804_.m_135372_(TICK_PARTICLES, (Object)4);
        this.f_19804_.m_135372_(MAX_AGE, (Object)30);
        this.f_19804_.m_135372_(HUGE_EXPLOSION, (Object)false);
        this.f_19804_.m_135372_(ROTATE_STATE, (Object)0);
        this.f_19804_.m_135372_(EXPLOSION_PARTICLE, (Object)ParticleTypes.f_123745_);
        this.f_19804_.m_135372_(TRAIL_PARTICLE, (Object)ParticleTypes.f_175827_);
        this.f_19804_.m_135372_(APPLY_FIRE_TICKS, (Object)0);
    }

    public void setAgeAndPoints(int maxAge, int explosionPoints, int tickParticleAmount) {
        this.f_19804_.m_135381_(MAX_AGE, (Object)maxAge);
        this.f_19804_.m_135381_(POINTS, (Object)explosionPoints);
        this.f_19804_.m_135381_(TICK_PARTICLES, (Object)tickParticleAmount);
    }

    public void setHugeExplosion(boolean bl) {
        this.f_19804_.m_135381_(HUGE_EXPLOSION, (Object)bl);
    }

    public void setRotateState(RotationState state) {
        for (int i = 0; i < RotationState.values().length; ++i) {
            if (!state.equals((Object)RotationState.values()[i])) continue;
            this.f_19804_.m_135381_(ROTATE_STATE, (Object)i);
        }
    }

    public RotationState getRotateState() {
        return RotationState.values()[(Integer)this.f_19804_.m_135370_(ROTATE_STATE)];
    }

    public int getMaxParticlePoints() {
        return (Integer)this.f_19804_.m_135370_(POINTS);
    }

    public int getTickParticleAmount() {
        return (Integer)this.f_19804_.m_135370_(TICK_PARTICLES);
    }

    public double getMaxAge() {
        return ((Integer)this.f_19804_.m_135370_(MAX_AGE)).intValue();
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3d = this.m_20184_();
        double e = vec3d.f_82479_;
        double f = vec3d.f_82480_;
        double g = vec3d.f_82481_;
        for (int i = 0; i < this.getTickParticleAmount(); ++i) {
            this.m_9236_().m_7106_(this.getTrailParticleType(), this.m_20185_() + e * (double)i / 4.0, this.m_20186_() + f * (double)i / 4.0, this.m_20189_() + g * (double)i / 4.0, -e, -f + 0.2, -g);
        }
        if ((double)this.f_19797_ > this.getMaxAge()) {
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_146870_();
    }

    public int m_150123_() {
        if (this.stackShotFrom != null) {
            return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)this.stackShotFrom);
        }
        return super.m_150123_();
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        if (entityHitResult.m_82443_() != null && entityHitResult.m_82443_() instanceof LivingEntity && this.m_7941_() != null) {
            float bonus = EnchantmentHelper.m_44833_((ItemStack)this.m_7941_(), (MobType)((LivingEntity)entityHitResult.m_82443_()).m_6336_());
            this.m_36781_(this.m_36789_() + (double)(bonus >= 5.0f ? bonus * 0.7f : bonus));
        }
        super.m_5790_(entityHitResult);
        if (this.getFireTicksOnHit() > 0 && entityHitResult.m_82443_() != null) {
            entityHitResult.m_82443_().m_7311_(this.getFireTicksOnHit());
        }
        this.m_146870_();
    }

    public void detonateEntity(Level world, double x, double y, double z, double points, float sizeModifier) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            world.m_6493_(this.getExplosionParticleType(), true, x, y, z, velocityX * (double)sizeModifier, velocityY * (double)sizeModifier, velocityZ * (double)sizeModifier);
            ++i;
        }
    }

    public void m_142036_() {
        super.m_142036_();
        if (((Boolean)this.f_19804_.m_135370_(HUGE_EXPLOSION)).booleanValue()) {
            this.detonateEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 750.0, 0.5f);
        } else {
            this.detonateEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getMaxParticlePoints(), 0.125f);
        }
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_11913_;
    }

    protected float m_6882_() {
        return 1.01f;
    }

    protected ItemStack m_7941_() {
        return this.stackShotFrom;
    }

    public void setItemStack(ItemStack stackShotFrom) {
        this.stackShotFrom = stackShotFrom;
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void setExplosionParticleType(ParticleOptions particle) {
        this.m_20088_().m_135381_(EXPLOSION_PARTICLE, (Object)particle);
    }

    public ParticleOptions getExplosionParticleType() {
        return (ParticleOptions)this.m_20088_().m_135370_(EXPLOSION_PARTICLE);
    }

    public void setTrailParticleType(ParticleOptions particle) {
        this.m_20088_().m_135381_(TRAIL_PARTICLE, (Object)particle);
    }

    public ParticleOptions getTrailParticleType() {
        return (ParticleOptions)this.m_20088_().m_135370_(TRAIL_PARTICLE);
    }

    public void applyFireTicks(int ticks) {
        this.f_19804_.m_135381_(APPLY_FIRE_TICKS, (Object)ticks);
    }

    public int getFireTicksOnHit() {
        return (Integer)this.f_19804_.m_135370_(APPLY_FIRE_TICKS);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Particle", this.getExplosionParticleType().m_5942_());
        nbt.m_128359_("TrailParticle", this.getExplosionParticleType().m_5942_());
        nbt.m_128405_("FireTicksOnHit", this.getFireTicksOnHit());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Particle", 8)) {
            try {
                this.setExplosionParticleType(ParticleArgument.m_247456_((StringReader)new StringReader(nbt.m_128461_("Particle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.m_128461_("Particle"), (Object)var5);
            }
        }
        if (nbt.m_128425_("TrailParticle", 8)) {
            try {
                this.setTrailParticleType(ParticleArgument.m_247456_((StringReader)new StringReader(nbt.m_128461_("TrailParticle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException var5) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.m_128461_("TrailParticle"), (Object)var5);
            }
        }
        if (nbt.m_128441_("FireTicksOnHit")) {
            this.applyFireTicks(nbt.m_128451_("FireTicksOnHit"));
        }
    }

    public static enum RotationState {
        NORMAL,
        SWIPE_FROM_RIGHT,
        SWIPE_FROM_LEFT;

    }
}

