/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.AreaEffectSphere;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.WeaponUtil;

public class DragonStaffProjectile
extends DragonFireball {
    private final ItemStack stack;
    private float radius = 2.0f;

    public DragonStaffProjectile(EntityType<? extends DragonStaffProjectile> entityType, Level world) {
        super(entityType, world);
        this.stack = new ItemStack((ItemLike)WeaponRegistry.DRAGON_STAFF.get());
    }

    public DragonStaffProjectile(Level world, LivingEntity user, ItemStack stack) {
        super((EntityType)EntityRegistry.DRAGON_STAFF_PROJECTILE.get(), world);
        this.m_5602_((Entity)user);
        this.m_19915_(user.m_146908_(), user.m_146909_());
        this.stack = stack;
    }

    protected void m_6532_(HitResult hitResult) {
        HitResult.Type type = hitResult.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)hitResult);
            this.m_9236_().m_214171_(GameEvent.f_157777_, hitResult.m_82450_(), GameEvent.Context.m_223719_((Entity)this, null));
        } else if (type == HitResult.Type.BLOCK) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            this.m_8060_(blockHitResult);
            BlockPos blockPos = blockHitResult.m_82425_();
            this.m_9236_().m_220407_(GameEvent.f_157777_, blockPos, GameEvent.Context.m_223719_((Entity)this, (BlockState)this.m_9236_().m_8055_(blockPos)));
        }
        this.detonate();
    }

    private void detonate() {
        if (!this.m_9236_().f_46443_) {
            List list = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(4.0, 2.0, 4.0));
            AreaEffectSphere areaEffectCloudEntity = new AreaEffectSphere(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
            Entity entity = this.m_19749_();
            if (entity instanceof LivingEntity) {
                areaEffectCloudEntity.setOwner((LivingEntity)entity);
            }
            areaEffectCloudEntity.setParticleType((ParticleOptions)ParticleTypes.f_123799_);
            areaEffectCloudEntity.setRadius(this.radius + (float)WeaponUtil.getEnchantDamageBonus(this.stack) / 2.5f);
            areaEffectCloudEntity.setDuration(200 + WeaponUtil.getEnchantDamageBonus(this.stack) * 20);
            areaEffectCloudEntity.setRadiusGrowth((3.0f - areaEffectCloudEntity.getRadius() + (float)WeaponUtil.getEnchantDamageBonus(this.stack) / 2.5f) / (float)areaEffectCloudEntity.getDuration());
            areaEffectCloudEntity.addEffect(new MobEffectInstance((MobEffect)EffectRegistry.HALLOWED_DRAGON_MIST.get(), 50, ConfigConstructor.dragon_staff_aura_strength));
            if (!list.isEmpty()) {
                for (LivingEntity livingEntity : list) {
                    double d = this.m_20280_((Entity)livingEntity);
                    if (!(d < 16.0)) continue;
                    areaEffectCloudEntity.m_6034_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
                    break;
                }
            }
            this.m_9236_().m_46796_(2006, this.m_20183_(), this.m_20067_() ? -1 : 1);
            this.m_9236_().m_7967_((Entity)areaEffectCloudEntity);
            this.m_146870_();
        }
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ >= 100) {
            this.detonate();
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("itemStack")) {
            this.stack.m_41751_((CompoundTag)nbt.m_128423_("itemStack"));
        }
        if (nbt.m_128441_("sphereRadius")) {
            this.radius = nbt.m_128457_("sphereRadius");
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.stack.m_41783_() != null) {
            nbt.m_128365_("itemStack", (Tag)this.stack.m_41783_());
        }
        nbt.m_128350_("sphereRadius", this.radius);
    }
}

