/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.projectile;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.WeaponRegistry;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class CometSpearEntity
extends AbstractArrow
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> ENCHANTED = SynchedEntityData.m_135353_(CometSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack spearStack;
    private final AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private boolean dealtDamage;

    public CometSpearEntity(EntityType<? extends CometSpearEntity> entityType, Level world) {
        super(entityType, world);
        this.spearStack = new ItemStack((ItemLike)WeaponRegistry.COMET_SPEAR.get());
    }

    public CometSpearEntity(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType)EntityRegistry.COMET_SPEAR_ENTITY_TYPE.get(), owner, world);
        this.spearStack = new ItemStack((ItemLike)WeaponRegistry.COMET_SPEAR.get());
        this.spearStack = stack.m_41777_();
        this.f_19804_.m_135381_(ENCHANTED, (Object)stack.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENCHANTED, (Object)false);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        if (this.f_19797_ > 100) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_8119_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    protected ItemStack m_7941_() {
        return this.spearStack.m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 currentPosition, Vec3 nextPosition) {
        return this.dealtDamage ? null : super.m_6351_(currentPosition, nextPosition);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        float f = ConfigConstructor.comet_spear_projectile_damage;
        if (entity == null) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.spearStack, (MobType)livingEntity.m_6336_());
            float healthPercentLeft = livingEntity.m_21223_() / livingEntity.m_21233_();
            if ((double)healthPercentLeft < 0.2) {
                f *= 2.0f;
            }
        }
        Entity entity2 = this.m_19749_();
        DamageSource damageSource = this.m_9236_().m_269111_().m_269390_((Entity)this, entity2);
        this.dealtDamage = true;
        SoundEvent soundEvent = SoundEvents.f_12514_;
        if (entity.m_6469_(damageSource, f)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity2 = (LivingEntity)entity;
                if (entity2 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity2, (Entity)entity2);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity2), (Entity)livingEntity2);
                }
                this.m_7761_(livingEntity2);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float g = 1.0f;
        this.m_5496_(soundEvent, g, 1.0f);
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_19749_() == null) {
            super.m_6123_(player);
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_5825_() {
        return true;
    }
}

