/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.mobs.ReturningKnight;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.WeaponRegistry;

public class Remnant
extends TamableAnimal {
    private int soulAmount = 3;

    public Remnant(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.m_7105_(false);
        this.initEquip();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> !this.m_21824_() || !(this.m_269323_() instanceof Player)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Remnant.class, true, entity -> {
            Remnant remnant;
            return !this.m_21824_() && entity instanceof Remnant && (remnant = (Remnant)((Object)entity)).m_21824_();
        }));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, entity -> entity instanceof Enemy && !(entity instanceof Creeper) && this.m_21824_() && !this.m_7307_((Entity)entity)));
        if (!this.m_21824_()) {
            this.f_21346_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{ReturningKnight.class, Moonknight.class, Remnant.class, DayStalker.class, NightProwler.class}).m_26044_(new Class[0]));
        } else {
            this.f_21346_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        }
    }

    public static AttributeSupplier.Builder createRemnantAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.3000000003).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void initEquip() {
        int[] chance = new int[]{6, 6, 2, 4, 1, 2, 2, 2};
        Item[] equipment = new Item[]{(Item)ArmorRegistry.SOUL_INGOT_HELMET.get(), (Item)ArmorRegistry.SOUL_INGOT_CHESTPLATE.get(), (Item)ArmorRegistry.SOUL_INGOT_LEGGINGS.get(), (Item)ArmorRegistry.SOUL_INGOT_BOOTS.get(), Items.f_42740_, (Item)WeaponRegistry.TRANSLUCENT_SWORD.get(), (Item)WeaponRegistry.TRANSLUCENT_GLAIVE.get(), (Item)WeaponRegistry.TRANSLUCENT_DOUBLE_GREATSWORD.get()};
        EquipmentSlot[] spot = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.OFFHAND, EquipmentSlot.MAINHAND, EquipmentSlot.MAINHAND, EquipmentSlot.MAINHAND};
        for (int i = 0; i < chance.length; ++i) {
            int random = new Random().nextInt(10);
            if (random >= chance[i]) continue;
            this.m_8061_(spot[i], new ItemStack((ItemLike)equipment[i]));
        }
    }

    public int getSoulAmount() {
        return this.soulAmount;
    }

    public void setSoulAmount(int amount) {
        this.soulAmount = amount;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.m_21839_(false);
        return super.m_6469_(source, amount);
    }

    public void m_8107_() {
        this.m_20260_(this.m_21825_());
        super.m_8107_();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_21830_((LivingEntity)player) && player.m_21120_(hand).m_41619_()) {
            this.m_21839_(!this.m_21827_());
            this.f_20899_ = false;
            this.f_21344_.m_26573_();
            this.m_6710_(null);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_7307_(Entity other) {
        if (other instanceof OwnableEntity && ((OwnableEntity)other).m_269323_() != null && this.m_269323_() != null && ((OwnableEntity)other).m_269323_() == this.m_269323_()) {
            return true;
        }
        return super.m_7307_(other);
    }

    public boolean m_21222_() {
        return true;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12043_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12046_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12045_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12047_;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public EntityGetter m_9236_() {
        return super.m_9236_();
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("soul_amount")) {
            this.soulAmount = nbt.m_128451_("soul_amount");
        }
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("soul_amount", this.soulAmount);
    }
}

