/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.mobs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.registry.ArmorRegistry;
import net.soulsweaponry.registry.WeaponRegistry;

public class Forlorn
extends Remnant {
    public Forlorn(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        Forlorn.initEquip((LivingEntity)this, Collections.emptyMap());
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
    }

    public static AttributeSupplier.Builder createForlornAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.3000000003).m_22268_(Attributes.f_22281_, 2.0);
    }

    @Override
    public int getSoulAmount() {
        return 10;
    }

    public static void initEquip(LivingEntity entity, Map<Enchantment, Integer> enchants) {
        HashMap<EquipmentSlot, ItemStack> equip = new HashMap<EquipmentSlot, ItemStack>();
        if (entity.m_217043_().m_188499_()) {
            equip.put(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WeaponRegistry.FORLORN_SCYTHE.get()));
        } else {
            equip.put(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)WeaponRegistry.GUTS_SWORD.get()));
        }
        equip.put(EquipmentSlot.HEAD, new ItemStack((ItemLike)ArmorRegistry.FORLORN_HELMET.get()));
        equip.put(EquipmentSlot.CHEST, new ItemStack((ItemLike)ArmorRegistry.FORLORN_CHESTPLATE.get()));
        equip.put(EquipmentSlot.LEGS, new ItemStack((ItemLike)ArmorRegistry.FORLORN_LEGGINGS.get()));
        equip.put(EquipmentSlot.FEET, new ItemStack((ItemLike)ArmorRegistry.FORLORN_BOOTS.get()));
        for (EquipmentSlot slot : equip.keySet()) {
            ItemStack item = (ItemStack)equip.get(slot);
            for (Enchantment enchant : enchants.keySet()) {
                if (!enchant.m_6081_(item)) continue;
                item.m_41663_(enchant, enchants.get(enchant).intValue());
            }
            entity.m_8061_(slot, item);
        }
    }
}

