/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.FreyrSwordEntity;
import net.soulsweaponry.util.CustomDamageSource;

public class FreyrSwordGoal
extends Goal {
    private final FreyrSwordEntity entity;
    private int attackTicks;
    private final double[][] hitFrames = new double[][]{{6.0, 1.0}, {13.0, 1.0}, {20.0, 1.1}, {29.0, 1.25}};
    private final double animationFrameCap = 3.5;

    public FreyrSwordGoal(FreyrSwordEntity entity) {
        this.entity = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity target = this.entity.m_5448_();
        return this.entity.m_269323_() != null && target != null && target.m_6084_() && this.entity.m_6779_(target);
    }

    public boolean m_8045_() {
        if (this.entity.m_269323_() != null && this.entity.m_5448_() != null) {
            if (!this.entity.isBlockPosNullish(this.entity.getStationaryPos()) && this.entity.m_20280_((Entity)this.entity.m_5448_()) > this.entity.getFollowRange()) {
                this.m_8041_();
                return false;
            }
            if (this.entity.m_269323_().m_20280_((Entity)this.entity.m_5448_()) > this.entity.getFollowRange()) {
                this.m_8041_();
                return false;
            }
        }
        return super.m_8045_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.setAnimationAttacking(false);
        this.attackTicks = 0;
        this.entity.m_6710_(null);
    }

    public void m_8037_() {
        LivingEntity target = this.entity.m_5448_();
        if (target != null) {
            this.attackTarget(target, this.entity.m_9236_());
        }
    }

    private void attackTarget(LivingEntity target, Level world) {
        ++this.attackTicks;
        if ((double)this.attackTicks >= this.animationFrameCap * 10.0) {
            this.attackTicks = 0;
        }
        this.entity.m_21563_().m_148051_((Entity)target);
        Vec3 vecTarget = this.entity.m_20154_().m_82549_(target.m_20182_());
        this.entity.m_20248_(vecTarget.m_7096_(), vecTarget.m_7098_(), vecTarget.m_7094_());
        this.entity.setAnimationAttacking(true);
        for (double[] hitFrame : this.hitFrames) {
            if ((double)this.attackTicks != hitFrame[0] || !target.m_6469_(CustomDamageSource.create(this.entity.m_9236_(), CustomDamageSource.FREYR_SWORD, (Entity)this.entity, (Entity)this.entity.m_269323_()), (float)((double)this.getAttackDamage(target) * hitFrame[1]))) continue;
            int fire = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)this.entity.asItemStack());
            if (fire > 0) {
                target.m_20254_(fire * 4);
            }
            if (!world.f_46443_) {
                ((ServerLevel)this.entity.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            } else {
                world.m_6493_((ParticleOptions)ParticleTypes.f_123766_, true, target.m_20185_(), target.m_20188_(), target.m_20189_(), 0.0, 0.0, 0.0);
            }
            world.m_5594_(null, this.entity.m_20183_(), SoundEvents.f_12317_, SoundSource.NEUTRAL, 0.8f, 1.0f);
        }
    }

    public float getAttackDamage(LivingEntity target) {
        return target != null ? (float)ConfigConstructor.sword_of_freyr_damage + EnchantmentHelper.m_44833_((ItemStack)this.entity.asItemStack(), (MobType)target.m_6336_()) : (float)ConfigConstructor.sword_of_freyr_damage;
    }
}

