/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.ai.goal;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.DayStalker;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.entity.mobs.WarmthEntity;
import net.soulsweaponry.entity.projectile.GrowingFireball;
import net.soulsweaponry.entity.projectile.MoonlightProjectile;
import net.soulsweaponry.entity.projectile.UntargetableFireball;
import net.soulsweaponry.entity.projectile.invisible.FlamePillar;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDeathHandler;
import org.jetbrains.annotations.Nullable;

public class DayStalkerGoal
extends MeleeAttackGoal {
    private final DayStalker boss;
    private int attackCooldown;
    private int specialCooldown;
    private int attackStatus;
    private int attackLength;
    private final int[] flamethrowerMeleeFrames = new int[]{18, 27, 41, 50, 58, 63};
    private float attackRotation;
    private double targetMaxY;
    private double targetY;
    private boolean hasExploded;
    private int changeFlightTargetTimer;
    private Vec3 flightPosAdder;
    private float flyY = 6.0f;
    private float fallDistance = 0.0f;

    public DayStalkerGoal(DayStalker boss, double speed, boolean pauseWhenMobIdle) {
        super((PathfinderMob)boss, speed, pauseWhenMobIdle);
        this.boss = boss;
    }

    public boolean m_8036_() {
        if (this.boss.isFlying() && this.boss.m_5448_() != null) {
            return true;
        }
        return super.m_8036_();
    }

    public void m_8041_() {
        super.m_8041_();
        int remainingTicks = this.attackLength - this.attackStatus;
        if (remainingTicks > 0) {
            this.boss.setWaitAnimation(true);
        }
        this.boss.setRemainingAniTicks(remainingTicks);
        this.attackCooldown = 20;
        this.specialCooldown = 20;
        this.attackStatus = 0;
        this.attackLength = 0;
        this.boss.setParticleState(0);
        this.hasExploded = false;
        this.boss.setFlying(false);
        this.changeFlightTargetTimer = 0;
        this.flyY = 6.0f;
        this.fallDistance = 0.0f;
        this.boss.flightTimer = 0;
    }

    private void checkAndSetAttack(LivingEntity target) {
        double distanceToEntity = this.boss.m_20280_((Entity)target);
        int rand = this.boss.m_217043_().m_188503_(DayStalker.ATTACKS_LENGTH);
        DayStalker.Attacks attack = DayStalker.Attacks.values()[rand];
        switch (attack) {
            case AIR_COMBUSTION: {
                this.boss.setAttackAnimation(attack);
                break;
            }
            case BLAZE_BARRAGE: 
            case SUNFIRE_RUSH: {
                if (!this.boss.isFlying() && !this.boss.isPhaseTwo() || this.isInMeleeRange(target)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case CONFLAGRATION: {
                if (!this.boss.isFlying() && (!this.boss.isPhaseTwo() || this.specialCooldown > 0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case DECIMATE: 
            case DAWNBREAKER: {
                if ((!this.isInMeleeRange(target) || this.boss.isFlying()) && !this.boss.isPhaseTwo()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case FLAMES_EDGE: {
                double d = this.boss.isPhaseTwo() ? 80.0 : 55.0;
                if (!(distanceToEntity < d) || this.boss.isFlying()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case CHAOS_STORM: {
                if (this.boss.isFlying() || !(distanceToEntity < 80.0) || this.specialCooldown > 0) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case FLAMETHROWER: {
                if (!this.boss.isFlying() && !this.boss.isPhaseTwo() || !(distanceToEntity < 260.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case RADIANCE: {
                if (!this.boss.isPhaseTwo() || !this.isInMeleeRange(target) || this.specialCooldown > 0) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case WARMTH: {
                if (!this.boss.isPhaseTwo() || this.specialCooldown > 0 || !this.boss.m_217043_().m_188499_()) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case OVERHEAT: 
            case INFERNO: {
                if (!this.boss.isPhaseTwo() || !(distanceToEntity < 200.0)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case FLAMES_REACH: {
                if (this.boss.isFlying()) break;
                double d = this.boss.isPhaseTwo() ? 140.0 : 120.0;
                if (!(distanceToEntity < d)) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            case SKY_HIGH: {
                if (!this.boss.isPhaseTwo() || this.specialCooldown > 0) break;
                this.boss.setAttackAnimation(attack);
                break;
            }
            default: {
                this.boss.setAttackAnimation(DayStalker.Attacks.IDLE);
            }
        }
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.boss.getRemainingAniTicks() > 0 || this.boss.getAttackAnimation().equals((Object)DayStalker.Attacks.SPAWN)) {
            return;
        }
        if (this.boss.isInitiatingPhaseTwo()) {
            this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 255));
            return;
        }
        this.attackCooldown = Math.max(this.attackCooldown - 1, 0);
        this.specialCooldown = Math.max(this.specialCooldown - 1, 0);
        if (!this.boss.isFlying() && this.boss.shouldChaseTarget()) {
            super.m_8037_();
        }
        if ((target = this.boss.m_5448_()) != null) {
            if (!this.boss.isPhaseTwo()) {
                this.tickPartnerSwitch();
            }
            if (this.boss.isFlying()) {
                this.moveAboveTarget(target);
            }
            double distanceToEntity = this.boss.m_20280_((Entity)target);
            if (this.attackCooldown <= 0 && this.boss.getAttackAnimation().equals((Object)DayStalker.Attacks.IDLE)) {
                this.checkAndSetAttack(target);
            }
            switch (this.boss.getAttackAnimation()) {
                case AIR_COMBUSTION: {
                    this.attackLength = 55;
                    this.airCombustion(target);
                    break;
                }
                case DECIMATE: {
                    this.attackLength = 60;
                    this.decimate(target);
                    break;
                }
                case DAWNBREAKER: {
                    this.attackLength = 40;
                    this.dawnbreaker(target);
                    break;
                }
                case CHAOS_STORM: {
                    this.attackLength = 90;
                    this.chaosStorm();
                    break;
                }
                case FLAMETHROWER: {
                    this.attackLength = 90;
                    this.flamethrower(target, distanceToEntity);
                    break;
                }
                case SUNFIRE_RUSH: {
                    this.attackLength = 117;
                    this.sunfireRush(target);
                    break;
                }
                case CONFLAGRATION: {
                    this.attackLength = this.boss.isPhaseTwo() ? 140 : 60;
                    this.conflagration(target);
                    break;
                }
                case BLAZE_BARRAGE: {
                    this.attackLength = 100;
                    this.blazeBarrage(target);
                    break;
                }
                case FLAMES_EDGE: {
                    this.attackLength = this.boss.isPhaseTwo() ? 90 : 60;
                    this.flamesEdge();
                    break;
                }
                case RADIANCE: {
                    this.attackLength = 120;
                    this.radiance();
                    break;
                }
                case WARMTH: {
                    this.attackLength = 100;
                    this.warmth();
                    break;
                }
                case OVERHEAT: {
                    this.attackLength = 100;
                    this.overheat(target);
                    break;
                }
                case INFERNO: {
                    this.attackLength = 160;
                    this.inferno();
                    break;
                }
                case FLAMES_REACH: {
                    this.attackLength = 60;
                    this.flamesReach(target, distanceToEntity);
                    break;
                }
                case SKY_HIGH: {
                    this.attackLength = 210;
                    this.skyHigh();
                }
            }
        }
    }

    private void tickPartnerSwitch() {
        NightProwler partner;
        int timer = Math.max(0, this.boss.flightTimer--);
        if (!this.boss.m_9236_().f_46443_ && (partner = this.boss.getPartner((ServerLevel)this.boss.m_9236_())) != null) {
            if (timer == 0) {
                partner.setFlying(!partner.isFlying());
                this.boss.setFlying(!this.boss.isFlying());
                this.boss.flightTimer = ConfigConstructor.duo_fight_time_before_switch;
            } else if (partner.isFlying() == this.boss.isFlying()) {
                boolean bl = this.boss.m_217043_().m_188499_();
                this.boss.setFlying(bl);
                partner.setFlying(!bl);
                this.boss.flightTimer = ConfigConstructor.duo_fight_time_before_switch;
            }
        }
    }

    private Vec3 randomizeVecAdder() {
        return new Vec3((double)(this.boss.m_217043_().m_216332_(3, 10) * (this.boss.m_217043_().m_188499_() ? -1 : 1)), 0.0, (double)(this.boss.m_217043_().m_216332_(3, 10) * (this.boss.m_217043_().m_188499_() ? -1 : 1)));
    }

    private void moveAboveTarget(LivingEntity target) {
        Vec3 vec3d2;
        this.boss.m_21563_().m_148051_((Entity)target);
        this.boss.m_21391_((Entity)target, this.boss.m_21529_(), this.boss.m_8132_());
        Vec3 vec3d = this.boss.m_20184_().m_82542_((double)0.8f, (double)0.6f, (double)0.8f);
        double d = vec3d.f_82480_;
        if (this.boss.m_20186_() < target.m_20186_() || this.boss.m_20186_() < target.m_20186_() + (double)this.flyY) {
            d = Math.max(0.0, d);
            d += 0.3 - d * (double)0.6f;
        }
        vec3d = new Vec3(vec3d.f_82479_, d, vec3d.f_82481_);
        if (this.flightPosAdder != null) {
            ++this.changeFlightTargetTimer;
            if (this.changeFlightTargetTimer >= 40) {
                this.flightPosAdder = this.randomizeVecAdder();
                this.changeFlightTargetTimer = 0;
            }
        } else {
            this.flightPosAdder = this.randomizeVecAdder();
        }
        if ((vec3d2 = new Vec3(target.m_20185_() - this.boss.m_20185_() + this.flightPosAdder.f_82479_, 0.0, target.m_20189_() - this.boss.m_20189_() + this.flightPosAdder.f_82481_)).m_165925_() > 9.0) {
            Vec3 vec3d3 = vec3d2.m_82541_();
            vec3d = vec3d.m_82520_(vec3d3.f_82479_ * 0.3 - vec3d.f_82479_ * 0.6, 0.0, vec3d3.f_82481_ * 0.3 - vec3d.f_82481_ * 0.6);
        }
        this.boss.m_20256_(vec3d);
    }

    private void checkAndReset(int attackCooldown, int specialCooldown) {
        if (this.attackStatus > this.attackLength) {
            this.attackStatus = 0;
            this.attackCooldown = Mth.m_14107_((double)((double)attackCooldown * (this.boss.isPhaseTwo() ? ConfigConstructor.day_stalker_cooldown_modifier_phase_2 : ConfigConstructor.day_stalker_cooldown_modifier_phase_1)));
            if (specialCooldown != 0) {
                this.specialCooldown = Mth.m_14107_((double)((double)specialCooldown * (this.boss.isPhaseTwo() ? ConfigConstructor.day_stalker_special_cooldown_modifier_phase_2 : ConfigConstructor.day_stalker_special_cooldown_modifier_phase_1)));
            }
            this.attackLength = 0;
            this.boss.setAttackAnimation(DayStalker.Attacks.IDLE);
            this.boss.setChaseTarget(true);
            this.hasExploded = false;
            this.flyY = 6.0f;
            this.fallDistance = 0.0f;
        }
    }

    private float getModifiedDamage(float damage) {
        return damage * ConfigConstructor.day_stalker_damage_modifier;
    }

    private boolean damageTarget(LivingEntity target, float damage) {
        if (this.boss.isPartner(target) || target instanceof WarmthEntity) {
            return false;
        }
        if (target.m_6469_(this.boss.m_9236_().m_269111_().m_269333_((LivingEntity)this.boss), this.getModifiedDamage(damage))) {
            if (this.boss.isEmpowered()) {
                target.m_20254_(2);
            }
            return true;
        }
        return false;
    }

    private void airCombustion(LivingEntity target) {
        ++this.attackStatus;
        if (this.attackStatus < 24 && target.m_20183_() != null) {
            this.boss.setTargetPos(new BlockPos(target.m_146903_(), (int)target.m_20188_(), target.m_146907_()));
        }
        this.boss.setChaseTarget(false);
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 255));
        this.boss.m_21563_().m_24964_(this.boss.getTargetPos().m_252807_());
        if (this.attackStatus >= 16 && this.attackStatus <= 25 && this.attackStatus % 4 == 0) {
            this.boss.m_9236_().m_5594_(null, this.boss.getTargetPos(), SoundEvents.f_11936_, SoundSource.HOSTILE, 1.0f, 1.0f);
            this.boss.m_9236_().m_5594_(null, this.boss.getTargetPos(), SoundEvents.f_12616_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus >= 20 && this.attackStatus <= 36 && !this.boss.m_9236_().f_46443_) {
            Vec3 center = Vec3.m_82512_((Vec3i)this.boss.getTargetPos());
            ParticleHandler.particleOutburst(this.boss.m_9236_(), 20, center.m_7096_(), center.m_7098_(), center.m_7094_(), (ParticleOptions)ParticleTypes.f_123744_, new Vec3(15.0, 15.0, 15.0), 1.0f);
        }
        if (this.attackStatus == 37 && !this.boss.m_9236_().f_46443_) {
            this.boss.m_9236_().m_5594_(null, this.boss.getTargetPos(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
            Vec3 pos = Vec3.m_82512_((Vec3i)this.boss.getTargetPos());
            ParticleEvents.airCombustionEvent(this.boss.m_9236_(), pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(this.boss.getTargetPos()).m_82400_(this.boss.isPhaseTwo() ? 2.0 : 1.0))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                this.damageTarget(living, 35.0f);
            }
        }
        this.checkAndReset(15, 0);
    }

    private void decimate(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 255));
        this.boss.m_21563_().m_148051_((Entity)target);
        if (this.attackStatus == 17) {
            this.playSound(this.boss.m_20183_(), (SoundEvent)SoundRegistry.DAY_STALKER_DECIMATE.get(), 1.0f, 1.0f);
        }
        if (this.attackStatus == 29) {
            if (this.isInMeleeRange(target) && this.damageTarget(target, 30.0f)) {
                target.m_5997_(0.0, 1.0, 0.0);
            }
            if (this.boss.isPhaseTwo()) {
                double d = Math.min(target.m_20186_(), this.boss.m_20186_());
                double e = Math.max(target.m_20186_(), this.boss.m_20186_()) + 1.0;
                float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.boss.m_20189_()), (double)(target.m_20185_() - this.boss.m_20185_()));
                for (int i = 0; i < 16; ++i) {
                    double h = 1.25 * (double)(i + 1);
                    BlockPos p = this.conjureFlames(this.boss.m_20185_() + (double)Mth.m_14089_((float)f) * h, this.boss.m_20189_() + (double)Mth.m_14031_((float)f) * h, d, e);
                    if (p == null) continue;
                    this.boss.m_9236_().m_46597_(p, Blocks.f_50083_.m_49966_());
                }
            }
        }
        if (this.attackStatus == 42) {
            boolean phase2 = this.boss.isPhaseTwo();
            this.shootSunlight(target, phase2 ? 1 : 0, phase2 ? 25.0f : 15.0f, MoonlightProjectile.RotationState.NORMAL);
        }
        this.checkAndReset(30, 0);
    }

    private void shootProjectile(LivingEntity target, Projectile projectile, SoundEvent sound) {
        double x = target.m_20185_() - this.boss.m_20185_();
        double y = target.m_20188_() - this.boss.m_20227_(1.0);
        double z = target.m_20189_() - this.boss.m_20189_();
        this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), sound, SoundSource.HOSTILE, 1.0f, 1.0f);
        if (target.m_20183_() != null) {
            this.boss.m_9236_().m_5594_(null, target.m_20183_(), sound, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        projectile.m_20343_(this.boss.m_20185_(), this.boss.m_20188_(), this.boss.m_20189_());
        projectile.m_6686_(x, y, z, 1.5f, 1.0f);
        this.boss.m_9236_().m_7967_((Entity)projectile);
    }

    private BlockPos conjureFlames(double x, double z, double maxY, double y) {
        BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
        boolean bl = false;
        double d = 0.0;
        do {
            VoxelShape voxelShape;
            BlockPos blockPos2 = blockPos.m_7495_();
            if (!this.boss.m_9236_().m_8055_(blockPos2).m_60783_((BlockGetter)this.boss.m_9236_(), blockPos2, Direction.UP)) continue;
            if (!this.boss.m_9236_().m_46859_(blockPos) && !(voxelShape = this.boss.m_9236_().m_8055_(blockPos).m_60812_((BlockGetter)this.boss.m_9236_(), blockPos)).m_83281_()) {
                d = voxelShape.m_83297_(Direction.Axis.Y);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
        if (bl) {
            return new BlockPos(blockPos.m_123341_(), (int)((double)blockPos.m_123342_() + d), blockPos.m_123343_());
        }
        return null;
    }

    private void chaosStorm() {
        ++this.attackStatus;
        this.boss.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 255));
        this.f_25540_.m_21573_().m_26573_();
        boolean phase2 = this.boss.isPhaseTwo();
        if (this.attackStatus == 1) {
            this.playSound(this.boss.m_20183_(), SoundEvents.f_12001_, 1.0f, 1.0f);
            int i = 0;
            ArrayList<BlockPos> list = new ArrayList<BlockPos>();
            list.add(new BlockPos(0, 0, 0));
            while (i < (phase2 ? 32 : 16)) {
                int x = this.boss.m_146903_() + this.boss.m_217043_().m_188503_(16) - 8;
                int y = this.boss.m_146904_();
                int z = this.boss.m_146907_() + this.boss.m_217043_().m_188503_(16) - 8;
                BlockPos pos = new BlockPos(x, y, z);
                for (BlockPos listPos : list) {
                    if (listPos == pos) continue;
                    FlamePillar pillar = new FlamePillar((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.FLAME_PILLAR.get()), this.boss.m_9236_());
                    pillar.m_36781_(this.getModifiedDamage(48.0f));
                    pillar.m_20343_(x, y, z);
                    pillar.m_5602_((Entity)this.boss);
                    pillar.setWarmup(i * 2);
                    this.boss.m_9236_().m_7967_((Entity)pillar);
                    ++i;
                }
            }
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 40, this.boss.isPhaseTwo() ? 0 : 60);
    }

    private void dawnbreaker(LivingEntity target) {
        ++this.attackStatus;
        this.f_25540_.m_21573_().m_26573_();
        if (this.attackStatus == 11 || this.attackStatus == 21) {
            this.playSound(null, SoundEvents.f_12317_, 1.0f, 1.0f);
            if (this.isInMeleeRange(target)) {
                this.damageTarget(target, 10.0f + (float)this.attackStatus / 2.0f);
                if (!this.boss.m_9236_().f_46443_) {
                    ((ServerLevel)this.boss.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.boss.isPhaseTwo()) {
                this.shootSunlight(target, 0, 20.0f, MoonlightProjectile.RotationState.NORMAL);
            }
        }
        if (this.attackStatus == 32) {
            this.playSound(null, SoundEvents.f_12317_, 1.0f, 0.75f);
            if (this.isInMeleeRange(target)) {
                this.damageTarget(target, 25.0f);
                if (!this.boss.m_9236_().f_46443_) {
                    ((ServerLevel)this.boss.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, target.m_20185_(), target.m_20188_(), target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            if (this.boss.isPhaseTwo()) {
                this.shootSunlight(target, 2, 30.0f, MoonlightProjectile.RotationState.NORMAL);
            }
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 20, 0);
    }

    private void shootSunlight(LivingEntity target, int typeIndex, float damage, MoonlightProjectile.RotationState rotationState) {
        if (typeIndex == 0) {
            MoonlightProjectile projectile = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.SUNLIGHT_PROJECTILE_SMALL.get()), this.boss.m_9236_(), (LivingEntity)this.boss);
            if (this.boss.isEmpowered()) {
                projectile.applyFireTicks(20);
            }
            projectile.setAgeAndPoints(15, 30, 2);
            projectile.m_36781_(this.getModifiedDamage(damage));
            projectile.setRotateState(rotationState);
            projectile.setExplosionParticleType((ParticleOptions)ParticleTypes.f_123744_);
            projectile.setTrailParticleType((ParticleOptions)ParticleTypes.f_175828_);
            this.shootProjectile(target, (Projectile)projectile, SoundEvents.f_11705_);
        } else if (typeIndex == 1) {
            MoonlightProjectile projectile = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.SUNLIGHT_PROJECTILE_BIG.get()), this.boss.m_9236_(), (LivingEntity)this.boss);
            if (this.boss.isEmpowered()) {
                projectile.applyFireTicks(40);
            }
            projectile.setAgeAndPoints(30, 150, 2);
            projectile.m_36781_(this.getModifiedDamage(damage));
            projectile.setRotateState(rotationState);
            projectile.setExplosionParticleType((ParticleOptions)ParticleTypes.f_123744_);
            projectile.setTrailParticleType((ParticleOptions)ParticleTypes.f_175828_);
            this.shootProjectile(target, (Projectile)projectile, SoundEvents.f_11705_);
        } else {
            MoonlightProjectile projectile = new MoonlightProjectile((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.VERTICAL_SUNLIGHT_PROJECTILE.get()), this.boss.m_9236_(), (LivingEntity)this.boss);
            if (this.boss.isEmpowered()) {
                projectile.applyFireTicks(60);
            }
            projectile.setAgeAndPoints(30, 75, 5);
            projectile.m_36781_(this.getModifiedDamage(damage));
            projectile.setHugeExplosion(true);
            projectile.setExplosionParticleType((ParticleOptions)ParticleTypes.f_123744_);
            projectile.setTrailParticleType((ParticleOptions)ParticleTypes.f_175828_);
            this.shootProjectile(target, (Projectile)projectile, SoundEvents.f_11705_);
        }
    }

    private void flamethrower(LivingEntity target, double distance) {
        ++this.attackStatus;
        if (this.attackStatus >= 20 && this.attackStatus < 65 && target.m_20183_() != null) {
            BlockPos targetPos;
            double length = 260.0;
            if (distance < length) {
                this.boss.setFlamethrowerTarget(target.m_20183_());
                targetPos = new BlockPos(target.m_146903_(), (int)target.m_20227_(0.5), target.m_146907_());
            } else {
                double x = target.m_146903_() - this.boss.m_146903_();
                double y = target.m_20227_(0.5) - (double)this.boss.m_146904_();
                double z = target.m_146907_() - this.boss.m_146907_();
                int newX = Mth.m_14107_((double)this.getPointBetweenTwoPos(length, distance, x, this.boss.m_146903_()));
                int newY = Mth.m_14165_((double)this.getPointBetweenTwoPos(length, distance, y, this.boss.m_146904_()));
                int newZ = Mth.m_14107_((double)this.getPointBetweenTwoPos(length, distance, z, this.boss.m_146907_()));
                targetPos = new BlockPos(newX, newY, newZ);
                this.boss.setFlamethrowerTarget(targetPos);
            }
            this.boss.setParticleState(1);
            if (this.attackStatus % 4 == 0) {
                AABB box = new AABB(targetPos.m_252807_(), this.boss.m_20182_()).m_82400_(1.0);
                for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, box)) {
                    LivingEntity living;
                    if (!(entity instanceof LivingEntity) || this.boss.isPartner(living = (LivingEntity)entity)) continue;
                    living.m_6469_(this.boss.m_269291_().m_269425_(), this.getModifiedDamage(this.boss.isPhaseTwo() ? 2.0f : 1.0f));
                    living.m_20254_(3);
                }
                this.playSound(targetPos, SoundEvents.f_11705_, 0.9f, 1.0f);
            }
            if (this.boss.isPhaseTwo()) {
                for (int frame : this.flamethrowerMeleeFrames) {
                    if (this.attackStatus != frame) continue;
                    this.aoeMelee(target, distance, 2.0, 15.0f);
                    this.playSound(null, SoundEvents.f_12317_, 1.0f, 1.0f);
                }
            }
        }
        if (this.attackStatus >= 65) {
            this.boss.setParticleState(0);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 50, 0);
    }

    private double getPointBetweenTwoPos(double maxDistance, double currentDistance, double vecValToTarget, int origin) {
        return (double)origin + maxDistance / currentDistance * vecValToTarget;
    }

    private BlockPos getPosBetweenTwoPos(double maxDistance, double currentDistance, Vec3 vecToTarget) {
        int newX = Mth.m_14107_((double)this.getPointBetweenTwoPos(maxDistance, currentDistance, vecToTarget.m_7096_(), this.boss.m_146903_()));
        int newY = Mth.m_14107_((double)this.getPointBetweenTwoPos(maxDistance, currentDistance, vecToTarget.m_7098_(), this.boss.m_146904_()));
        int newZ = Mth.m_14107_((double)this.getPointBetweenTwoPos(maxDistance, currentDistance, vecToTarget.m_7094_(), this.boss.m_146907_()));
        return new BlockPos(newX, newY, newZ);
    }

    private void aoeMelee(LivingEntity target, double distanceToTarget, double expansion, float damage) {
        BlockPos pos;
        double maxDistance = this.m_6639_(target);
        if (this.isInMeleeRange(target)) {
            pos = target.m_20183_();
        } else {
            double x = target.m_146903_() - this.boss.m_146903_();
            double y = target.m_20188_() - (double)this.boss.m_146904_();
            double z = target.m_146907_() - this.boss.m_146907_();
            pos = this.getPosBetweenTwoPos(maxDistance, distanceToTarget, new Vec3(x, y, z));
        }
        for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(pos).m_82400_(expansion))) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            this.damageTarget(living, damage);
        }
    }

    private void sunfireRush(LivingEntity target) {
        ++this.attackStatus;
        if (this.attackStatus == 45 || this.attackStatus == 60) {
            this.shootSunlight(target, 0, 15.0f, MoonlightProjectile.RotationState.NORMAL);
        } else if (this.attackStatus == 71) {
            this.shootSunlight(target, 1, 20.0f, MoonlightProjectile.RotationState.SWIPE_FROM_RIGHT);
        } else if (this.attackStatus == 83) {
            this.shootSunlight(target, 1, 20.0f, MoonlightProjectile.RotationState.SWIPE_FROM_LEFT);
        } else if (this.attackStatus == 96) {
            this.shootSunlight(target, 2, 25.0f, MoonlightProjectile.RotationState.NORMAL);
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 70, 0);
    }

    private void conflagration(LivingEntity target) {
        ++this.attackStatus;
        boolean phase2 = this.boss.isPhaseTwo();
        if (!phase2) {
            if (this.attackStatus >= 20 && this.attackStatus <= 40 && this.attackStatus % 4 == 0) {
                double f = target.m_20185_() - this.boss.m_20185_();
                double g = target.m_20227_(0.5) - (this.boss.m_20188_() + 1.5);
                double h = target.m_20189_() - this.boss.m_20189_();
                UntargetableFireball fireballEntity = new UntargetableFireball(this.boss.m_9236_(), (LivingEntity)this.boss, f, g, h, 2);
                fireballEntity.m_6034_(this.boss.m_20185_(), this.boss.m_20188_() + 1.0, fireballEntity.m_20189_());
                this.boss.m_9236_().m_7967_((Entity)fireballEntity);
            }
        } else {
            this.boss.m_21573_().m_26573_();
            if (this.attackStatus == 15) {
                GrowingFireball fireballEntity = new GrowingFireball(this.boss.m_9236_(), (Entity)this.boss);
                fireballEntity.m_6034_(this.boss.m_20185_(), this.boss.m_20188_() + 4.0, this.boss.m_20189_());
                fireballEntity.setTargetUuid(target.m_20148_());
                fireballEntity.setRadiusGrowth(5.0f / (float)fireballEntity.getMaxAge());
                this.boss.m_9236_().m_7967_((Entity)fireballEntity);
            }
        }
        this.checkAndReset(phase2 ? 20 : 80, phase2 ? 160 : 0);
    }

    private void blazeBarrage(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        for (int i = 0; i < (this.boss.isPhaseTwo() ? 2 : 1); ++i) {
            double x = target.m_20185_() - this.boss.m_20185_();
            double y = target.m_20188_() - this.boss.m_20227_(1.0);
            double z = target.m_20189_() - this.boss.m_20189_();
            Vec3 vec3d = this.boss.m_20252_(1.0f);
            SmallFireball fireball = new SmallFireball(this.boss.m_9236_(), this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), x, y, z);
            fireball.m_6034_(this.boss.m_20185_() + vec3d.f_82479_ * (double)this.boss.m_217043_().m_188503_(6) * (double)(this.boss.m_217043_().m_188499_() ? -1 : 1), this.boss.m_20227_(0.5) + (double)this.boss.m_217043_().m_188503_(4) - 1.0, this.boss.m_20189_() + vec3d.f_82481_ * (double)this.boss.m_217043_().m_188503_(6) * (double)(this.boss.m_217043_().m_188499_() ? -1 : 1));
            this.boss.m_9236_().m_7967_((Entity)fireball);
            if (this.attackStatus % 4 != 0) continue;
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_11705_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        this.checkAndReset(40, 0);
    }

    private void flamesEdge() {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        if (!this.boss.isPhaseTwo()) {
            this.boss.setFlamesEdgeRadius(5.0f);
            if (this.attackStatus >= 5 && this.attackStatus < 22) {
                this.boss.setParticleState(2);
            } else if (this.attackStatus >= 22 && this.attackStatus <= 24) {
                this.boss.setParticleState(3);
            } else if (this.attackStatus >= 25) {
                this.boss.setParticleState(0);
            }
            if (this.attackStatus == 22) {
                this.playSound(null, (SoundEvent)SoundRegistry.DAY_STALKER_FLAMES_EDGE_NORMAL.get(), 1.0f, 1.0f);
                this.aoe(3.3, 35.0f, 1.0f);
            }
        } else {
            this.boss.setFlamesEdgeRadius(6.5f);
            if (this.attackStatus >= 20 && this.attackStatus < 41) {
                this.boss.setParticleState(2);
            } else if (this.attackStatus >= 41 && this.attackStatus <= 43) {
                this.boss.setParticleState(3);
            } else if (this.attackStatus >= 44) {
                this.boss.setParticleState(0);
            }
            if (this.attackStatus == 41) {
                this.playSound(null, (SoundEvent)SoundRegistry.DAY_STALKER_FLAMES_EDGE_EMPOWERED.get(), 1.0f, 1.0f);
                this.aoe(5.2, 40.0f, 1.5f);
            }
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 30, 0);
    }

    public void aoe(double expansion, float damage, float knockback) {
        for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, this.boss.m_20191_().m_82400_(expansion))) {
            LivingEntity target;
            if (!(entity instanceof LivingEntity) || !this.damageTarget(target = (LivingEntity)entity, damage) || !(knockback > 0.0f)) continue;
            double x = target.m_20185_() - this.boss.m_20185_();
            double z = target.m_20189_() - this.boss.m_20189_();
            target.m_147240_((double)knockback, -x, -z);
        }
    }

    private void radiance() {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        if (this.attackStatus == 75) {
            this.playSound(null, (SoundEvent)SoundRegistry.DAY_STALKER_RADIANCE.get(), 1.0f, 1.0f);
        }
        if (this.attackStatus == 80) {
            CustomDeathHandler.deathExplosionEvent(this.boss.m_9236_(), this.boss.m_20182_(), (SoundEvent)SoundRegistry.DAWNBREAKER_EVENT.get(), new ParticleOptions[]{ParticleTypes.f_123755_, ParticleTypes.f_123744_});
            this.aoe(4.0, 60.0f, 4.0f);
        }
        this.checkAndReset(40, 140);
    }

    private void warmth() {
        ++this.attackStatus;
        if (this.attackStatus == 84) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_12031_, SoundSource.HOSTILE, 1.0f, 1.0f);
            for (int i = 0; i < 4; ++i) {
                WarmthEntity entity = new WarmthEntity((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.WARMTH_ENTITY.get()), this.boss.m_9236_());
                Vec3 pos = new Vec3(this.boss.m_20185_() + (double)(this.boss.m_217043_().m_216332_(2, 5) * (this.boss.m_217043_().m_188499_() ? -1 : 1)), this.boss.m_20186_() + (double)this.boss.m_217043_().m_188503_(4) + 2.0, this.boss.m_20189_() + (double)(this.boss.m_217043_().m_216332_(2, 5) * (this.boss.m_217043_().m_188499_() ? -1 : 1)));
                entity.m_146884_(this.getAirBlockPos(pos, 0));
                this.boss.m_9236_().m_7967_((Entity)entity);
            }
        }
        this.checkAndReset(20, 160);
    }

    private void overheat(LivingEntity target) {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        if (this.attackStatus == 1) {
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), (SoundEvent)SoundRegistry.OVERHEAT_CHARGE_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            this.boss.m_9236_().m_5594_(null, target.m_20183_(), (SoundEvent)SoundRegistry.OVERHEAT_CHARGE_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        if (this.attackStatus <= 57) {
            this.targetMaxY = Math.min(target.m_20186_(), this.boss.m_20186_());
            this.targetY = Math.max(target.m_20186_(), this.boss.m_20186_()) + 1.0;
            this.attackRotation = (float)Mth.m_14136_((double)(target.m_20189_() - this.boss.m_20189_()), (double)(target.m_20185_() - this.boss.m_20185_()));
        }
        if (this.attackStatus == 67 && this.attackRotation != 0.0f && this.targetY != 0.0 && this.targetMaxY != 0.0) {
            double d = this.targetMaxY;
            double e = this.targetY;
            float f = this.attackRotation;
            int length = 20;
            for (int i = 0; i <= length; ++i) {
                double h = 1.25 * (double)(i + 1) / 1.5;
                BlockPos pos = this.conjureFlames(this.boss.m_20185_() + (double)Mth.m_14089_((float)f) * h, this.boss.m_20189_() + (double)Mth.m_14031_((float)f) * h, d, e);
                if (pos == null) continue;
                Vec3 vec = pos.m_252807_();
                FlamePillar pillar = new FlamePillar((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.FLAME_PILLAR.get()), this.boss.m_9236_());
                pillar.m_36781_(this.getModifiedDamage(40.0f));
                pillar.m_20343_(vec.m_7096_(), pos.m_123342_(), vec.m_7094_());
                pillar.setRadius(2.5f);
                pillar.setParticleDivergence(4.0f);
                pillar.setParticleMod(1.5f);
                pillar.m_5602_((Entity)this.boss);
                pillar.setWarmup(-6);
                this.boss.m_9236_().m_7967_((Entity)pillar);
                this.boss.m_9236_().m_5594_(null, pos, SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
                ++i;
            }
        }
        this.checkAndReset(40, 0);
    }

    private void inferno() {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        if (this.attackStatus == 23) {
            this.playSound(null, SoundEvents.f_11705_, 1.0f, 1.0f);
            this.boss.setFlying(true);
            this.boss.m_5997_(0.0, 0.75, 0.0);
        }
        if (this.attackStatus == 69) {
            this.boss.setFlying(false);
            this.boss.m_20334_(0.0, -2.0, 0.0);
        }
        if (this.attackStatus >= 70 && this.attackStatus <= 100 && this.boss.m_20096_() && !this.hasExploded) {
            this.boss.m_9236_().m_254849_((Entity)this.boss, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 6.0f, Level.ExplosionInteraction.NONE);
            this.hasExploded = true;
        }
        if (this.attackStatus == 125) {
            this.boss.m_9236_().m_254849_((Entity)this.boss, this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), 8.0f, Level.ExplosionInteraction.NONE);
        }
        this.checkAndReset(30, 0);
    }

    private void skyHigh() {
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        if (this.attackStatus == 23) {
            this.playSound(null, SoundEvents.f_11705_, 1.0f, 1.0f);
            this.playSound(null, (SoundEvent)SoundRegistry.NIGHT_PROWLER_SCREAM.get(), 1.0f, 1.0f);
            this.boss.setFlying(true);
            this.flyY = 30.0f;
            this.boss.m_5997_(0.0, 1.5, 0.0);
        }
        if (this.attackStatus == 142) {
            this.boss.setFlying(false);
            this.boss.m_20334_(0.0, -3.0, 0.0);
        }
        if (this.boss.f_19789_ > this.fallDistance) {
            this.fallDistance = this.boss.f_19789_;
        }
        if (this.attackStatus >= 146 && this.attackStatus <= 190 && this.boss.m_20096_() && !this.hasExploded) {
            float pDistance;
            float power = 20.0f + this.fallDistance;
            float expansion = this.fallDistance / 2.5f;
            AABB box = this.boss.m_20191_().m_82400_((double)expansion);
            for (Entity targets : this.boss.m_9236_().m_45933_((Entity)this.boss, box)) {
                if (!(targets instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)targets;
                this.damageTarget(livingEntity, power);
            }
            this.boss.m_9236_().m_5594_(null, this.boss.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
            float f = pDistance = this.fallDistance >= 10.0f ? this.fallDistance / 10.0f : 1.0f;
            if (!this.boss.m_9236_().f_46443_) {
                ParticleHandler.particleOutburstMap(this.boss.m_9236_(), Mth.m_14143_((float)(200.0f * pDistance)), this.boss.m_20185_(), this.boss.m_20186_(), this.boss.m_20189_(), ParticleEvents.DEFAULT_GRAND_SKYFALL_MAP, pDistance);
            }
            this.hasExploded = true;
        }
        this.checkAndReset(5, 80);
    }

    private void flamesReach(LivingEntity target, double distance) {
        double maxDistance;
        ++this.attackStatus;
        this.boss.m_21573_().m_26573_();
        double d = maxDistance = this.boss.isPhaseTwo() ? 140.0 : 120.0;
        if (this.attackStatus == 5) {
            this.playSound(null, (SoundEvent)SoundRegistry.DAY_STALKER_WINDUP.get(), 1.0f, 1.0f);
        }
        if (this.attackStatus == 29) {
            BlockPos targetPos;
            if (distance < maxDistance) {
                targetPos = target.m_20183_();
            } else {
                double x = target.m_146903_() - this.boss.m_146903_();
                double y = target.m_20188_() - (double)this.boss.m_146904_();
                double z = target.m_146907_() - this.boss.m_146907_();
                int newX = Mth.m_14107_((double)this.getPointBetweenTwoPos(maxDistance, distance, x, this.boss.m_146903_()));
                int newY = Mth.m_14107_((double)this.getPointBetweenTwoPos(maxDistance, distance, y, this.boss.m_146904_()));
                int newZ = Mth.m_14107_((double)this.getPointBetweenTwoPos(maxDistance, distance, z, this.boss.m_146907_()));
                targetPos = new BlockPos(newX, newY, newZ);
            }
            AABB box = new AABB(targetPos.m_252807_(), this.boss.m_20182_()).m_82400_(1.0);
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, box)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                this.damageTarget(living, 20.0f);
                double x = target.m_20185_() - this.boss.m_20185_();
                double z = target.m_20189_() - this.boss.m_20189_();
                target.m_147240_(3.0, x, z);
            }
            this.playSound(targetPos, (SoundEvent)SoundRegistry.DAY_STALKER_PULL.get(), 1.0f, 1.0f);
        }
        if (this.attackStatus == 43) {
            Vec3 vec3d = this.boss.m_20252_(1.0f);
            Vec3 pos = new Vec3((double)this.boss.m_146903_() + vec3d.f_82479_ * 3.0, (double)this.boss.m_146904_(), (double)this.boss.m_146907_() + vec3d.f_82481_ * 3.0);
            BlockPos blockPos = BlockPos.m_274446_((Position)pos);
            if (!this.boss.m_9236_().f_46443_) {
                ParticleHandler.particleOutburstMap(this.boss.m_9236_(), 150, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), ParticleEvents.DARKIN_BLADE_SLAM_MAP, 1.0f);
            }
            this.playSound(blockPos, SoundEvents.f_11913_, 1.0f, 1.0f);
            for (Entity entity : this.boss.m_9236_().m_45933_((Entity)this.boss, new AABB(blockPos).m_82400_(3.0))) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                this.damageTarget(living, 25.0f);
            }
        }
        this.checkAndReset(this.boss.isPhaseTwo() ? 10 : 40, 0);
    }

    private void playSound(@Nullable BlockPos pos, SoundEvent sound, float volume, float pitch) {
        if (pos == null) {
            pos = this.boss.m_20183_();
        }
        this.boss.m_9236_().m_5594_(null, pos, sound, SoundSource.HOSTILE, volume, pitch);
    }

    private Vec3 getAirBlockPos(Vec3 start, int counter) {
        if (this.boss.m_9236_().m_8055_(BlockPos.m_274446_((Position)start)).m_60795_() || counter >= 5) {
            return start;
        }
        return this.getAirBlockPos(start.m_82520_(0.0, 1.0, 0.0), counter + 1);
    }

    protected void m_6739_(LivingEntity target, double squaredDistance) {
    }

    protected boolean isInMeleeRange(LivingEntity target) {
        double distanceToEntity = this.boss.m_20280_((Entity)target);
        return distanceToEntity <= this.m_6639_(target);
    }
}

