/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.blocks;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WitherRoseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.soulsweaponry.blocks.Withered;
import net.soulsweaponry.blocks.WitheredBlock;

public class WitheredFlower
extends WitherRoseBlock
implements Withered {
    private final Supplier<MobEffect> effect;
    public static final BooleanProperty CANNOT_TURN = BooleanProperty.m_61465_((String)"can_turn");
    private static final Supplier<List<Block>> SMALL_FLOWERS = () -> BuiltInRegistries.f_256975_.m_123024_().filter(block -> block.m_49966_().m_204336_(BlockTags.f_13037_)).toList();

    public WitheredFlower(Supplier<MobEffect> effect, BlockBehaviour.Properties settings) {
        super(MobEffects.f_19615_, settings);
        this.effect = effect;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CANNOT_TURN});
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Block getBlockToReturnAs() {
        return this.getRandomFlower();
    }

    private Block getRandomFlower() {
        return SMALL_FLOWERS.get().get(new Random().nextInt(SMALL_FLOWERS.get().size()));
    }

    @Override
    public boolean canTurn(BlockGetter world, BlockPos pos, int maxNeighbors) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122159_((Vec3i)pos, Direction.DOWN);
        return !(world.m_8055_((BlockPos)mutable).m_60734_() instanceof WitheredBlock) && (Boolean)world.m_8055_(pos).m_61143_((Property)CANNOT_TURN) == false;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (world.f_46443_ || world.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(this.effect.get(), 40));
        }
    }

    protected boolean m_6266_(BlockState floor, BlockGetter world, BlockPos pos) {
        return super.m_6266_(floor, world, pos) || floor.m_60713_(Blocks.f_50134_) || floor.m_60713_(Blocks.f_50135_) || floor.m_60713_(Blocks.f_50136_) || floor.m_60713_(Blocks.f_50259_);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (this.canTurn((BlockGetter)world, pos, 0)) {
            this.turnBack(world, pos);
        }
        DebugPackets.m_133708_((Level)world, (BlockPos)pos);
    }
}

