/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.entity.mobs.DraugrBoss;
import net.soulsweaponry.entity.mobs.Moonknight;
import net.soulsweaponry.entity.mobs.ReturningKnight;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.ParticleRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.registry.WeaponRegistry;

public class AltarBlock
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;

    public AltarBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (world.f_46443_ && random.m_188503_(5) < 2) {
            double e = 0.5;
            double d = 0.375;
            double f = 0.375;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + d + e, (double)pos.m_123342_() + e + d * (double)1.8f, (double)pos.m_123343_() + f + e, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() - d + e, (double)pos.m_123342_() + e + d * (double)1.8f, (double)pos.m_123343_() - f + e, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() + d + e, (double)pos.m_123342_() + e + d * (double)1.8f, (double)pos.m_123343_() - f + e, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)pos.m_123341_() - d + e, (double)pos.m_123342_() + e + d * (double)1.8f, (double)pos.m_123343_() + f + e, 0.0, 0.0, 0.0);
            this.particleCircle(world, pos, 4);
        }
    }

    private void particleCircle(Level world, BlockPos pos, int r) {
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        double y = (float)pos.m_123342_() + 0.2f;
        for (int theta = 0; theta < 360; theta += 2) {
            float x0 = (float)pos.m_123341_() + 0.5f;
            float z0 = (float)pos.m_123343_() + 0.5f;
            double x = (double)x0 + (double)r * Math.cos((double)theta * Math.PI / 180.0);
            double z = (double)z0 + (double)r * Math.sin((double)theta * Math.PI / 180.0);
            world.m_7106_((ParticleOptions)this.getParticleType(), x, y, z, 0.0, 0.0, 0.0);
            if (theta % 72 != 0) continue;
            points.add(new Vec3(x, y, z));
        }
        this.particlePentagon(world, r, points, y);
        HashMap<Vec3, Vec3> map1 = new HashMap<Vec3, Vec3>();
        HashMap<Vec3, Vec3> map2 = new HashMap<Vec3, Vec3>();
        map1.put((Vec3)points.get(0), (Vec3)points.get(2));
        map1.put((Vec3)points.get(0), (Vec3)points.get(3));
        map1.put((Vec3)points.get(1), (Vec3)points.get(3));
        map1.put((Vec3)points.get(1), (Vec3)points.get(4));
        map1.put((Vec3)points.get(2), (Vec3)points.get(0));
        map2.put((Vec3)points.get(2), (Vec3)points.get(4));
        map2.put((Vec3)points.get(3), (Vec3)points.get(0));
        map2.put((Vec3)points.get(3), (Vec3)points.get(1));
        map2.put((Vec3)points.get(4), (Vec3)points.get(1));
        map2.put((Vec3)points.get(4), (Vec3)points.get(2));
        this.particleStar(world, r, map1, y);
        this.particleStar(world, r, map2, y);
    }

    private void particlePentagon(Level world, int modifier, List<Vec3> points, double y) {
        for (int i = 0; i < points.size(); ++i) {
            Vec3 start = points.get(i);
            Vec3 target = i == points.size() - 1 ? points.get(0) : points.get(i + 1);
            double e = target.m_7096_() - start.m_7096_();
            double g = target.m_7094_() - start.m_7094_();
            double h = Math.sqrt(e * e + g * g);
            double x = start.m_7096_();
            double z = start.m_7094_();
            e /= h;
            g /= h;
            double length = 0.0;
            for (int k = 0; k < 6 * modifier; ++k) {
                world.m_7106_((ParticleOptions)this.getParticleType(), x + e * (length += 5.0 * (double)modifier / 100.0), y, z + g * length, 0.0, 0.0, 0.0);
            }
        }
    }

    private void particleStar(Level world, int modifier, HashMap<Vec3, Vec3> map, double y) {
        for (Vec3 start : map.keySet()) {
            Vec3 target = map.get(start);
            double e = target.m_7096_() - start.m_7096_();
            double g = target.m_7094_() - start.m_7094_();
            double h = Math.sqrt(e * e + g * g);
            double x = start.m_7096_();
            double z = start.m_7094_();
            e /= h;
            g /= h;
            double length = 0.0;
            for (int k = 0; k < 6 * modifier; ++k) {
                world.m_7106_((ParticleOptions)this.getParticleType(), x + e * (length += 7.5 * (double)modifier / 100.0), y, z + g * length, 0.0, 0.0, 0.0);
            }
        }
    }

    private SimpleParticleType getParticleType() {
        return (SimpleParticleType)ParticleRegistry.NIGHTFALL_PARTICLE.get();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_((Item)ItemRegistry.LOST_SOUL.get())) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            ReturningKnight boss = new ReturningKnight((EntityType<? extends ReturningKnight>)((EntityType)EntityRegistry.RETURNING_KNIGHT.get()), world);
            boss.m_20343_(pos.m_123341_(), (float)pos.m_123342_() + 0.1f, pos.m_123343_());
            boss.setSpawning(true);
            world.m_5594_(null, pos, (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            world.m_7967_((Entity)boss);
            world.m_7471_(pos, false);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_((Item)WeaponRegistry.DRAUGR.get())) {
            DraugrBoss boss = new DraugrBoss((EntityType<? extends DraugrBoss>)((EntityType)EntityRegistry.DRAUGR_BOSS.get()), world);
            boss.m_20343_(pos.m_123341_(), (float)pos.m_123342_() + 0.1f, pos.m_123343_());
            boss.setSpawning();
            world.m_5594_(null, pos, (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            world.m_7967_((Entity)boss);
            world.m_7471_(pos, false);
            return InteractionResult.SUCCESS;
        }
        if (itemStack.m_150930_((Item)ItemRegistry.ESSENCE_OF_EVENTIDE.get())) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            Moonknight boss = new Moonknight((EntityType<? extends Monster>)((EntityType)EntityRegistry.MOONKNIGHT.get()), world);
            boss.m_20343_(pos.m_123341_(), (float)pos.m_123342_() + 0.1f, pos.m_123343_());
            boss.setSpawning(true);
            world.m_5594_(null, pos, (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            world.m_7967_((Entity)boss);
            world.m_7471_(pos, false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_7820_().m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }
}

