/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.common.items;

import com.mojang.util.UUIDTypeAdapter;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.ironchests.common.blocks.GenericChestBlockEntity;
import tech.thatgravyboat.ironchests.common.items.KeyItem;
import tech.thatgravyboat.ironchests.common.utils.ModUtils;

public class KeyRingItem
extends KeyItem {
    public KeyRingItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public boolean hasChest(ItemStack stack) {
        return stack.m_41782_() && this.getKeys(stack).m_128440_() > 0;
    }

    @Override
    public boolean canAddNewChest(ItemStack stack) {
        return !stack.m_41782_() || this.getKeys(stack).m_128440_() < 8;
    }

    @Override
    public boolean canUseOn(Player player, ItemStack stack, GenericChestBlockEntity chest) {
        if (this.hasChest(stack)) {
            for (String uuid : this.getKeys(stack).m_128431_()) {
                try {
                    if (!chest.isRightKey(UUIDTypeAdapter.fromString((String)uuid))) continue;
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return false;
    }

    @Override
    public void addKey(ItemStack stack, GenericChestBlockEntity chest) {
        if (chest.getKeyId() != null) {
            CompoundTag keys = this.getKeys(stack);
            CompoundTag key = new CompoundTag();
            key.m_128365_("chest", (Tag)NbtUtils.m_129224_((BlockPos)chest.m_58899_()));
            key.m_128359_("chestType", Component.Serializer.m_130703_((Component)chest.m_5446_()));
            keys.m_128365_(UUIDTypeAdapter.fromUUID((UUID)chest.getKeyId()), (Tag)key);
            CompoundTag orCreateTag = stack.m_41784_();
            orCreateTag.m_128365_("keys", (Tag)keys);
            stack.m_41751_(orCreateTag);
        }
    }

    private CompoundTag getKeys(ItemStack stack) {
        return stack.m_41784_().m_128469_("keys");
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
        list.add((Component)Component.m_237115_((String)"item.key.keyring.desc"));
        ModUtils.getTag(stack).ifPresent(ctag -> ctag.m_128469_("keys").m_128431_().forEach(uuid -> {
            CompoundTag tag = ctag.m_128469_("keys").m_128469_(uuid);
            if (tag.m_128441_("chest") && tag.m_128441_("chestType")) {
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("chest"));
                MutableComponent chestType = Component.Serializer.m_130701_((String)tag.m_128461_("chestType"));
                if (chestType != null) {
                    list.add((Component)Component.m_237110_((String)"item.key.keychest", (Object[])new Object[]{chestType, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}));
                }
            }
        }));
        super.m_7373_(stack, level, list, tooltipFlag);
    }
}

