/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.ironchests.api.property.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import tech.thatgravyboat.ironchests.api.property.SoundTypeHelper;
import tech.thatgravyboat.ironchests.api.property.base.BlockProperty;
import tech.thatgravyboat.ironchests.api.property.base.BlockPropertyType;

public record BuilderProperty(int lightLevel, boolean noCollision, boolean noOcclusion, boolean noDrops, boolean requiresCorrectToolForDrops, float friction, float speedFactor, float jumpFactor, float destroyTime, float explosionResistance, SoundType soundType) implements BlockProperty
{
    public static final Type TYPE = new Type();

    @Override
    public BlockBehaviour.Properties getProperties() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_284310_();
        properties.m_155954_(this.destroyTime());
        properties.m_155956_(this.explosionResistance());
        if (this.noCollision) {
            properties.m_60910_();
        }
        properties.m_60953_(state -> this.lightLevel());
        properties.m_60918_(this.soundType());
        properties.m_60911_(this.friction());
        properties.m_60956_(this.speedFactor());
        if (this.noOcclusion) {
            properties.m_60955_();
        }
        if (this.requiresCorrectToolForDrops) {
            properties.m_60999_();
        }
        if (this.noDrops) {
            properties.m_222994_();
        }
        properties.m_60967_(this.jumpFactor());
        return properties;
    }

    @Override
    public BlockPropertyType getType() {
        return TYPE;
    }

    private static class Type
    implements BlockPropertyType {
        private static final Codec<SoundType> SOUND_CODEC = Codec.STRING.comapFlatMap(SoundTypeHelper::getSound, Object::toString);
        private static final Codec<BuilderProperty> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)15).fieldOf("lightLevel").orElse((Object)0).forGetter(Type.get(0)), (App)Codec.BOOL.fieldOf("noCollision").orElse((Object)false).forGetter(Type.get(false)), (App)Codec.BOOL.fieldOf("noOcclusion").orElse((Object)false).forGetter(Type.get(false)), (App)Codec.BOOL.fieldOf("noDrops").orElse((Object)false).forGetter(Type.get(false)), (App)Codec.BOOL.fieldOf("requiresCorrectToolForDrops").orElse((Object)false).forGetter(Type.get(false)), (App)Codec.FLOAT.fieldOf("friction").orElse((Object)Float.valueOf(0.6f)).forGetter(Type.get(Float.valueOf(0.6f))), (App)Codec.FLOAT.fieldOf("speedFactor").orElse((Object)Float.valueOf(1.0f)).forGetter(Type.get(Float.valueOf(1.0f))), (App)Codec.FLOAT.fieldOf("jumpFactor").orElse((Object)Float.valueOf(1.0f)).forGetter(Type.get(Float.valueOf(1.0f))), (App)Codec.FLOAT.fieldOf("destroyTime").orElse((Object)Float.valueOf(0.0f)).forGetter(Type.get(Float.valueOf(0.0f))), (App)Codec.FLOAT.fieldOf("explosionResistance").orElse((Object)Float.valueOf(0.0f)).forGetter(Type.get(Float.valueOf(0.0f))), (App)SOUND_CODEC.fieldOf("sound").forGetter(Type.get(SoundType.f_56742_))).apply((Applicative)instance, BuilderProperty::new));

        private Type() {
        }

        private static <E, T> Function<E, T> get(T type) {
            return e -> type;
        }

        public Codec<BuilderProperty> codec() {
            return CODEC;
        }

        @Override
        public String getId() {
            return "builder";
        }
    }
}

