/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.client;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import me.paypur.tconjei.ColorProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="tconjei", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModEventHandler {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        File folder = new File("resourcepacks");
        File copy = new File(folder, "tconjeidark.zip");
        folder.mkdirs();
        if (copy.exists()) {
            copy.delete();
        }
        try {
            int read;
            folder.mkdirs();
            ResourceLocation texture = new ResourceLocation("tconjei", "tconjeidark.zip");
            InputStream in = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(texture).get()).m_215507_();
            FileOutputStream out = new FileOutputStream(copy);
            byte[] buffer = new byte[4096];
            while ((read = in.read(buffer)) > 0) {
                out.write(buffer, 0, read);
                out.flush();
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            LogUtils.getLogger().error("Failed to copy built-in resource pack", (Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onClientReload(TextureStitchEvent.Post event) {
        try {
            InputStream stream = ((Resource)Minecraft.m_91087_().m_91098_().m_213713_(new ResourceLocation("tconjei", "textures/gui/palette.png")).get()).m_215507_();
            BufferedImage image = ImageIO.read(stream);
            ColorProvider.TEXT = image.getRGB(0, 0);
            stream.close();
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            LogUtils.getLogger().error("Error loading palette", (Throwable)e);
        }
    }
}

