/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RequestState {
    private final Map<ProviderPipe, List<ItemStack>> itemsToWithdraw;
    private final Map<BlockPos, List<ItemStack>> itemsToRoute;
    private final List<ItemStack> missingStacks;
    private final Set<Item> uniqueCraftedItems;
    private final List<ItemStack> spareStacks;

    public RequestState() {
        this.itemsToWithdraw = new HashMap<ProviderPipe, List<ItemStack>>();
        this.itemsToRoute = new HashMap<BlockPos, List<ItemStack>>();
        this.missingStacks = new ArrayList<ItemStack>();
        this.uniqueCraftedItems = new HashSet<Item>();
        this.spareStacks = new ArrayList<ItemStack>();
    }

    private RequestState(Map<ProviderPipe, List<ItemStack>> itemsToWithdraw, Map<BlockPos, List<ItemStack>> itemsToRoute, List<ItemStack> missingStacks, Set<Item> uniqueCraftedItems, List<ItemStack> spareStacks) {
        this.itemsToWithdraw = itemsToWithdraw;
        this.itemsToRoute = itemsToRoute;
        this.missingStacks = missingStacks;
        this.uniqueCraftedItems = uniqueCraftedItems;
        this.spareStacks = spareStacks;
    }

    public RequestState copy() {
        HashMap<ProviderPipe, List<ItemStack>> copiedItemsToWithdraw = new HashMap<ProviderPipe, List<ItemStack>>();
        for (Map.Entry<ProviderPipe, List<ItemStack>> entry : this.itemsToWithdraw.entrySet()) {
            ArrayList arrayList = new ArrayList();
            entry.getValue().forEach(withdrawStack -> copiedWithdrawStacks.add(withdrawStack.m_41777_()));
            copiedItemsToWithdraw.put(entry.getKey(), arrayList);
        }
        HashMap<BlockPos, List<ItemStack>> copiedItemsToRoute = new HashMap<BlockPos, List<ItemStack>>();
        for (Map.Entry<BlockPos, List<ItemStack>> entry : this.itemsToRoute.entrySet()) {
            ArrayList copiedRouteStacks = new ArrayList();
            entry.getValue().forEach(routeStack -> copiedRouteStacks.add(routeStack.m_41777_()));
            copiedItemsToRoute.put(entry.getKey(), copiedRouteStacks);
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        this.spareStacks.forEach(spareStack -> copiedSpareStacks.add(spareStack.m_41777_()));
        return new RequestState(copiedItemsToWithdraw, copiedItemsToRoute, this.missingStacks, new HashSet<Item>(this.uniqueCraftedItems), arrayList);
    }

    public void restore(RequestState backupState) {
        this.itemsToWithdraw.clear();
        this.itemsToWithdraw.putAll(backupState.itemsToWithdraw);
        this.itemsToRoute.clear();
        this.itemsToRoute.putAll(backupState.itemsToRoute);
        this.uniqueCraftedItems.clear();
        this.uniqueCraftedItems.addAll(backupState.uniqueCraftedItems);
        this.spareStacks.clear();
        this.spareStacks.addAll(backupState.spareStacks);
    }

    public int amountAlreadyWithdrawing(ProviderPipe providerPipe, ItemStack stack) {
        int amount = 0;
        if (this.itemsToWithdraw.containsKey(providerPipe)) {
            for (ItemStack withdrawStack : this.itemsToWithdraw.get(providerPipe)) {
                if (!ItemStack.m_150942_((ItemStack)withdrawStack, (ItemStack)stack)) continue;
                amount += withdrawStack.m_41613_();
            }
        }
        return amount;
    }

    public void scheduleItemWithdrawal(ProviderPipe providerPipe, ItemStack stack) {
        if (this.itemsToWithdraw.containsKey(providerPipe)) {
            MiscUtil.mergeStackIntoList(this.itemsToWithdraw.get(providerPipe), stack);
        } else {
            ArrayList<ItemStack> withdrawStacks = new ArrayList<ItemStack>();
            withdrawStacks.add(stack);
            this.itemsToWithdraw.put(providerPipe, withdrawStacks);
        }
    }

    public void scheduleItemRouting(BlockPos requestPos, ItemStack stack) {
        boolean matched = false;
        for (BlockPos pos : this.itemsToRoute.keySet()) {
            if (!pos.equals((Object)requestPos)) continue;
            MiscUtil.mergeStackIntoList(this.itemsToRoute.get(pos), stack);
            matched = true;
            break;
        }
        if (!matched) {
            ArrayList<ItemStack> stacksToRoute = new ArrayList<ItemStack>();
            stacksToRoute.add(stack);
            this.itemsToRoute.put(requestPos, stacksToRoute);
        }
    }

    public void addMissingStack(ItemStack stack) {
        this.missingStacks.add(stack);
    }

    public int missingStacksSize() {
        return this.missingStacks.size();
    }

    public void reduceMissingStacks(int targetSize) {
        while (this.missingStacks.size() > targetSize) {
            this.missingStacks.remove(this.missingStacks.size() - 1);
        }
    }

    public List<ItemStack> collateMissingStacks() {
        ArrayList<ItemStack> collatedStacks = new ArrayList<ItemStack>();
        for (ItemStack missingStack : this.missingStacks) {
            MiscUtil.mergeStackIntoList(collatedStacks, missingStack);
        }
        return collatedStacks;
    }

    public Map<BlockPos, List<ItemStack>> getItemsToRoute() {
        return this.itemsToRoute;
    }

    public Map<ProviderPipe, List<ItemStack>> getItemsToWithdraw() {
        return this.itemsToWithdraw;
    }

    public void addCraftedItem(ItemStack stack) {
        this.uniqueCraftedItems.add(stack.m_41720_());
    }

    public int getUniqueCrafts() {
        return this.uniqueCraftedItems.size();
    }

    public void addSpareStack(ItemStack stack) {
        MiscUtil.mergeStackIntoList(this.spareStacks, stack);
    }

    public List<ItemStack> getSpareStacks() {
        return this.spareStacks;
    }
}

