/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.inventory.container.SingleItemFilterContainer;
import jagm.classicpipes.inventory.menu.RoutingPipeMenu;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class RoutingPipeEntity
extends NetworkedPipeEntity
implements MenuProvider {
    private final SingleItemFilterContainer filter = new SingleItemFilterContainer(this, 9, false);
    private boolean defaultRoute = false;

    public RoutingPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.ROUTING_PIPE_ENTITY, pos, state);
    }

    @Override
    public void m_142466_(CompoundTag valueInput) {
        this.filter.m_6211_();
        super.m_142466_(valueInput);
        ListTag filterList = valueInput.m_128437_("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.m_128451_("slot");
                MiscUtil.loadFromTag(tag, ItemStack.f_41582_, stack -> this.filter.m_6836_(slot, (ItemStack)stack));
            }
        });
        this.filter.setMatchComponents(valueInput.m_128471_("match_components"));
        this.defaultRoute = valueInput.m_128471_("default_route");
    }

    @Override
    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        ListTag filterList = new ListTag();
        for (int slot = 0; slot < this.filter.m_6643_(); ++slot) {
            ItemStack stack = this.filter.m_8020_(slot);
            if (stack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.f_41582_, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.m_128365_("filter", (Tag)filterList);
        valueOutput.m_128379_("match_components", this.filter.shouldMatchComponents());
        valueOutput.m_128379_("default_route", this.defaultRoute);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.classicpipes.routing_pipe");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new RoutingPipeMenu(id, playerInventory, this.filter, this.defaultRoute);
    }

    public boolean shouldMatchComponents() {
        return this.filter.shouldMatchComponents();
    }

    @Override
    public boolean isDefaultRoute() {
        return this.defaultRoute;
    }

    public void setDefaultRoute(boolean defaultRoute) {
        this.defaultRoute = defaultRoute;
        if (defaultRoute) {
            this.getNetwork().addPipe(this);
        } else {
            this.getNetwork().getDefaultRoutes().remove((Object)this);
        }
    }

    public Filter.MatchingResult canRouteItemHere(ItemStack stack) {
        return this.filter.matches(stack);
    }
}

