/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.MatchingPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.menu.MatchingPipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MatchingPipeEntity
extends NetworkedPipeEntity
implements MenuProvider,
MatchingPipe {
    private boolean matchComponents = false;
    private final List<ItemStack> cache = new ArrayList<ItemStack>();
    private boolean cacheInitialised = false;
    private final List<ItemStack> cannotFit = new ArrayList<ItemStack>();

    public MatchingPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.MATCHING_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        if (!this.cacheInitialised && !((FacingOrNone)((Object)state.m_61143_((Property)MatchingPipeBlock.FACING))).equals((Object)FacingOrNone.NONE)) {
            this.updateCache(level, pos, ((FacingOrNone)((Object)state.m_61143_((Property)MatchingPipeBlock.FACING))).getDirection());
            this.cacheInitialised = true;
        }
        super.tickServer(level, pos, state);
    }

    private void updateCache(ServerLevel level, BlockPos pos, Direction facing) {
        this.cache.clear();
        this.cannotFit.clear();
        this.cache.addAll(Services.LOADER_SERVICE.getContainerItems(level, pos.m_121945_(facing), facing.m_122424_()));
    }

    @Override
    public void updateCache() {
        this.cacheInitialised = false;
    }

    @Override
    public boolean matches(ItemStack stack) {
        for (ItemStack cannotFitStack : this.cannotFit) {
            if (!ItemStack.m_150942_((ItemStack)cannotFitStack, (ItemStack)stack)) continue;
            return false;
        }
        for (ItemStack containerStack : this.cache) {
            if (!stack.m_150930_(containerStack.m_41720_()) || this.shouldMatchComponents() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)containerStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NetworkedPipeEntity getAsPipe() {
        return this;
    }

    @Override
    public void markCannotFit(ItemStack stack) {
        this.cannotFit.add(stack);
    }

    @Override
    public void m_142466_(CompoundTag valueInput) {
        this.cacheInitialised = false;
        super.m_142466_(valueInput);
        this.matchComponents = valueInput.m_128471_("match_components");
    }

    @Override
    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        valueOutput.m_128379_("match_components", this.shouldMatchComponents());
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.classicpipes.matching_pipe");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new MatchingPipeMenu(id, playerInventory, this.shouldMatchComponents(), this);
    }

    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
    }
}

