/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class PipeBlock
extends HalfTransparentBlock
implements SimpleWaterloggedBlock,
EntityBlock,
Equipable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected final VoxelShape[] shapeByIndex;

    public PipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes();
    }

    private VoxelShape[] makeShapes() {
        float a = 0.25f;
        float f = 0.5f - a;
        float f1 = 0.5f + a;
        VoxelShape voxelshape = Block.m_49796_((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f));
        VoxelShape[] avoxelshape = new VoxelShape[6];
        for (int i = 0; i < 6; ++i) {
            Direction direction = Direction.m_122376_((int)i);
            avoxelshape[i] = Shapes.m_83048_((double)(0.5 + Math.min((double)(-a), (double)direction.m_122429_() * 0.5)), (double)(0.5 + Math.min((double)(-a), (double)direction.m_122430_() * 0.5)), (double)(0.5 + Math.min((double)(-a), (double)direction.m_122431_() * 0.5)), (double)(0.5 + Math.max((double)a, (double)direction.m_122429_() * 0.5)), (double)(0.5 + Math.max((double)a, (double)direction.m_122430_() * 0.5)), (double)(0.5 + Math.max((double)a, (double)direction.m_122431_() * 0.5)));
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        for (int k = 0; k < 64; ++k) {
            VoxelShape voxelshape1 = voxelshape;
            for (int j = 0; j < 6; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = Shapes.m_83110_((VoxelShape)voxelshape1, (VoxelShape)avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        return avoxelshape1;
    }

    public abstract boolean isPipeConnected(BlockState var1, Direction var2);

    public abstract BlockState setPipeConnected(BlockState var1, Direction var2, boolean var3);

    protected boolean canConnect(Level level, BlockPos pipePos, Direction direction) {
        BlockPos neighbourPos = pipePos.m_121945_(direction);
        Block block = level.m_8055_(neighbourPos).m_60734_();
        if (block instanceof PipeBlock) {
            PipeBlock pipeBlock = (PipeBlock)block;
            return PipeBlock.canConnectToPipeBothWays(this, pipeBlock);
        }
        return Services.LOADER_SERVICE.canAccessContainer(level, neighbourPos, direction.m_122424_());
    }

    protected static boolean canConnectToPipeBothWays(PipeBlock pipe1, PipeBlock pipe2) {
        return pipe1.canConnectToPipe(pipe2) && pipe2.canConnectToPipe(pipe1);
    }

    protected boolean canConnectToPipe(PipeBlock pipeBlock) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_263224_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_192917_((Fluid)Fluids.f_76193_)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pipePos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pipePos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        boolean wasConnected = this.isPipeConnected(state, direction);
        boolean willConnect = this.canConnect((Level)level, pipePos, direction);
        BlockState newState = this.setPipeConnected(state, direction, willConnect);
        if (wasConnected != willConnect && (blockEntity = level.m_7702_(pipePos)) instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                pipe.scheduleUpdate(serverLevel, newState, pipePos, direction, wasConnected);
            }
        }
        return newState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeByIndex[this.getAABBIndex(state)];
    }

    protected int getAABBIndex(BlockState state) {
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            if (!this.isPipeConnected(state, Direction.m_122376_((int)j))) continue;
            i |= 1 << j;
        }
        return i;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (!(this instanceof FluidPipeBlock) && level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).m_7702_(pos)) instanceof ItemPipeEntity) {
            ItemPipeEntity pipe = (ItemPipeEntity)blockEntity;
            pipe.dropItems(serverLevel, pos);
        }
        super.m_5707_(level, pos, state, player);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)blockEntity;
            return pipe.getComparatorOutput();
        }
        return 0;
    }

    public EquipmentSlot m_40402_() {
        return EquipmentSlot.HEAD;
    }

    public InteractionResultHolder<ItemStack> m_269277_(Item item, Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.m_19100_((Object)player.m_21120_(hand));
    }
}

