/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.registry.soil;

import com.davenonymous.bonsaitrees3.BonsaiTrees3;
import com.davenonymous.bonsaitrees3.registry.soil.SoilInfo;
import com.davenonymous.libnonymous.helper.BlockStateSerializationHelper;
import com.davenonymous.libnonymous.helper.FluidStateSerializationHelper;
import com.davenonymous.libnonymous.serialization.JsonHelpers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class SoilSerializer
implements RecipeSerializer<SoilInfo> {
    public SoilInfo fromJson(ResourceLocation recipeId, JsonObject json) {
        SoilInfo result;
        JsonObject display;
        Ingredient soil = JsonHelpers.getIngredientFromArrayOrSingle((JsonElement)json.get("soil"));
        if (soil.m_43947_()) {
            BonsaiTrees3.LOGGER.info("Skipping recipe '{}', contains unknown soil ingredient.", (Object)recipeId);
            return null;
        }
        float tickModifier = 1.0f;
        if (json.has("tickModifier")) {
            tickModifier = json.get("tickModifier").getAsFloat();
        }
        if ((display = json.getAsJsonObject("display")).has("fluid")) {
            state = FluidStateSerializationHelper.deserializeFluidState((JsonObject)display);
            result = new SoilInfo(recipeId, soil, state, tickModifier);
        } else if (display.has("texture")) {
            ResourceLocation texture = new ResourceLocation(display.get("texture").getAsString());
            result = new SoilInfo(recipeId, soil, texture, tickModifier);
        } else {
            state = BlockStateSerializationHelper.deserializeBlockState((JsonObject)display);
            result = new SoilInfo(recipeId, soil, (BlockState)state, tickModifier);
        }
        if (json.has("compatibleSoilTags")) {
            JsonArray tagsJson = json.getAsJsonArray("compatibleSoilTags");
            for (JsonElement element : tagsJson) {
                String tag;
                if (!element.isJsonPrimitive() || (tag = element.getAsString()) == null) continue;
                result.addTag(tag);
            }
        }
        return result;
    }

    @Nullable
    public SoilInfo fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        SoilInfo.SoilType soilType = (SoilInfo.SoilType)buffer.m_130066_(SoilInfo.SoilType.class);
        Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        float tickModifier = buffer.readFloat();
        SoilInfo result = switch (soilType) {
            case SoilInfo.SoilType.FLUID -> new SoilInfo(recipeId, ingredient, FluidStateSerializationHelper.deserializeFluidState((FriendlyByteBuf)buffer), tickModifier);
            case SoilInfo.SoilType.TEXTURE -> new SoilInfo(recipeId, ingredient, buffer.m_130281_(), tickModifier);
            default -> new SoilInfo(recipeId, ingredient, BlockStateSerializationHelper.deserializeBlockState((FriendlyByteBuf)buffer), tickModifier);
        };
        int tagCount = buffer.readInt();
        for (int i = 0; i < tagCount; ++i) {
            result.addTag(buffer.m_130277_());
        }
        return result;
    }

    public void toNetwork(FriendlyByteBuf buffer, SoilInfo soil) {
        buffer.m_130068_((Enum)soil.soilType);
        soil.ingredient.m_43923_(buffer);
        buffer.writeFloat(soil.tickModifier);
        switch (soil.soilType) {
            case FLUID: {
                FluidStateSerializationHelper.serializeFluidState((FriendlyByteBuf)buffer, (FluidState)soil.fluidState);
                break;
            }
            case TEXTURE: {
                buffer.m_130085_(soil.soilTexture);
                break;
            }
            default: {
                BlockStateSerializationHelper.serializeBlockState((FriendlyByteBuf)buffer, (BlockState)soil.blockState);
            }
        }
        buffer.writeInt(soil.tags.size());
        for (String tag : soil.tags) {
            buffer.m_130070_(tag);
        }
    }
}

