/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.network;

import com.davenonymous.libnonymous.base.BasePacket;
import com.davenonymous.libnonymous.gui.framework.WidgetSlot;
import com.davenonymous.libnonymous.serialization.Sync;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.network.NetworkEvent;

public class PacketEnabledSlots
extends BasePacket {
    @Sync
    boolean[] enabledSlots;

    public PacketEnabledSlots(List<Slot> slots) {
        this.enabledSlots = new boolean[slots.size()];
        int index = 0;
        for (Slot slot : slots) {
            if (slot instanceof WidgetSlot) {
                WidgetSlot ws = (WidgetSlot)slot;
                this.enabledSlots[index] = ws.isEnabled();
            }
            ++index;
        }
    }

    public PacketEnabledSlots(boolean[] enabledSlots) {
        this.enabledSlots = enabledSlots;
    }

    public PacketEnabledSlots(FriendlyByteBuf buf) {
        super(buf);
    }

    public void doWork(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer serverPlayer = ctx.get().getSender();
        int index = 0;
        for (Slot slot : serverPlayer.f_36096_.f_38839_) {
            if (slot instanceof WidgetSlot) {
                if (index >= this.enabledSlots.length) break;
                ((WidgetSlot)slot).setEnabled(this.enabledSlots[index]);
            }
            ++index;
        }
    }
}

