/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.client;

import com.davenonymous.bonsaitrees3.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees3.client.BonsaiPotModelLoader;
import com.davenonymous.libnonymous.render.QuadBaker;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class BonsaiPotBakedModel
implements IDynamicBakedModel {
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ItemOverrides overrides;
    private final ItemTransforms itemTransforms;
    private final Map<BlockState, List<BakedQuad>> quadCache = new HashMap<BlockState, List<BakedQuad>>();
    private final Map<FluidState, List<BakedQuad>> fluidQuadCache = new HashMap<FluidState, List<BakedQuad>>();
    private final Map<ResourceLocation, List<BakedQuad>> textureCache = new HashMap<ResourceLocation, List<BakedQuad>>();
    private final BakedModel potModel;

    public BonsaiPotBakedModel(ModelState modelState, Function<Material, TextureAtlasSprite> spriteGetter, ItemOverrides overrides, ItemTransforms itemTransforms, BakedModel potModel) {
        this.spriteGetter = spriteGetter;
        this.overrides = overrides;
        this.itemTransforms = itemTransforms;
        this.potModel = potModel;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        boolean hasTexture;
        if (side != null || renderType != null && !renderType.equals(RenderType.m_110451_())) {
            return Collections.emptyList();
        }
        BlockState soilBlock = (BlockState)extraData.get(BonsaiPotBlockEntity.SOIL_BLOCK);
        FluidState fluidBlock = (FluidState)extraData.get(BonsaiPotBlockEntity.FLUID_BLOCK);
        ResourceLocation soilTexture = (ResourceLocation)extraData.get(BonsaiPotBlockEntity.SOIL_TEXTURE);
        boolean hasBlock = soilBlock != null && !soilBlock.m_60795_();
        boolean hasFluid = fluidBlock != null && !fluidBlock.m_76178_();
        boolean bl = hasTexture = soilTexture != null;
        if (!(hasFluid || hasBlock || hasTexture)) {
            return this.potModel.getQuads(state, side, rand, extraData, renderType);
        }
        if (hasTexture) {
            if (!this.textureCache.containsKey(soilTexture)) {
                ArrayList<BakedQuad> potQuads = new ArrayList<BakedQuad>(this.potModel.getQuads(state, side, rand, extraData, renderType));
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(soilTexture);
                float height = 0.125f;
                BakedQuad quad = QuadBaker.createQuad((Vec3)new Vec3((double)0.1f, (double)height, (double)0.1f), (Vec3)new Vec3((double)0.1f, (double)height, (double)0.9f), (Vec3)new Vec3((double)0.9f, (double)height, (double)0.9f), (Vec3)new Vec3((double)0.9f, (double)height, (double)0.1f), (Transformation)Transformation.m_121093_(), (TextureAtlasSprite)sprite, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                potQuads.add(quad);
                this.textureCache.put(soilTexture, potQuads);
            }
            return this.textureCache.get(soilTexture);
        }
        if (hasBlock) {
            if (!this.quadCache.containsKey(soilBlock)) {
                ArrayList potQuads = new ArrayList(this.potModel.getQuads(state, side, rand, extraData, renderType));
                Transformation transformation = new Transformation(new Matrix4f().scale(0.0625f, 0.0625f, 0.0625f));
                transformation = transformation.m_121096_(new Transformation(new Matrix4f().translate(2.0f, 1.1f, 2.0f)));
                transformation = transformation.m_121096_(new Transformation(new Matrix4f().scale(12.0f, 1.0f, 12.0f)));
                IQuadTransformer quadTransformer = QuadTransformers.applying((Transformation)transformation);
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(soilBlock);
                quadTransformer.process(model.getQuads(soilBlock, Direction.UP, rand, ModelData.EMPTY, renderType)).forEach(potQuads::add);
                this.quadCache.put(soilBlock, potQuads);
            }
            return this.quadCache.get(soilBlock);
        }
        if (hasFluid) {
            if (!this.fluidQuadCache.containsKey(fluidBlock)) {
                ArrayList<BakedQuad> potQuads = new ArrayList<BakedQuad>(this.potModel.getQuads(state, side, rand, extraData, renderType));
                IClientFluidTypeExtensions fluidStyle = IClientFluidTypeExtensions.of((Fluid)fluidBlock.m_76152_());
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStyle.getStillTexture());
                int i = fluidStyle.getTintColor();
                float alpha = (float)(i >> 24 & 0xFF) / 255.0f;
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                float height = 0.125f;
                BakedQuad quad = QuadBaker.createQuad((Vec3)new Vec3((double)0.1f, (double)height, (double)0.1f), (Vec3)new Vec3((double)0.1f, (double)height, (double)0.9f), (Vec3)new Vec3((double)0.9f, (double)height, (double)0.9f), (Vec3)new Vec3((double)0.9f, (double)height, (double)0.1f), (Transformation)Transformation.m_121093_(), (TextureAtlasSprite)sprite, (float)r, (float)g, (float)b, (float)alpha);
                potQuads.add(quad);
                this.fluidQuadCache.put(fluidBlock, potQuads);
            }
            return this.fluidQuadCache.get(fluidBlock);
        }
        return Collections.emptyList();
    }

    @Nullable
    private TextureAtlasSprite getFluidTexture(FluidStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        TextureAtlasSprite[] sprites = ForgeHooksClient.getFluidSprites((BlockAndTintGetter)mc.f_91073_, (BlockPos)BlockPos.f_121853_, (FluidState)stack.getFluid().m_76145_());
        return sprites.length > 0 ? sprites[0] : null;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.spriteGetter.apply(BonsaiPotModelLoader.BONSAIPOT_BRICKS_MATERIAL);
    }

    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public ItemTransforms m_7442_() {
        return this.itemTransforms;
    }
}

