/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.legacydeserializers;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.AddedByAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ColorAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.EnchantAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.FluidContentsAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.InTagAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.attributes.ShulkerFillLevelAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.legacydeserializers.StandardTraitsLegacyDeserializer;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;

public class AllItemAttributeLegacyDeserializers {
    @ApiStatus.Internal
    public static void register() {
        AllItemAttributeLegacyDeserializers.addLegacyDeserializer(new StandardTraitsLegacyDeserializer());
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("in_tag", (CompoundTag tag) -> new InTagAttribute((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation(tag.m_128461_("space"), tag.m_128461_("path")))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("in_item_group", AllItemAttributeTypes.IN_ITEM_GROUP);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("added_by", (CompoundTag tag) -> new AddedByAttribute(tag.m_128461_("id")));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("has_enchant", (CompoundTag tag) -> new EnchantAttribute((Enchantment)BuiltInRegistries.f_256876_.m_7745_(ResourceLocation.m_135820_((String)tag.m_128461_("id")))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("shulker_fill_level", (CompoundTag tag) -> new ShulkerFillLevelAttribute(ShulkerFillLevelAttribute.ShulkerLevels.fromKey(tag.m_128461_("id"))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("has_color", (CompoundTag tag) -> new ColorAttribute(DyeColor.m_41053_((int)tag.m_128451_("id"))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("has_fluid", (CompoundTag tag) -> new FluidContentsAttribute((Fluid)BuiltInRegistries.f_257020_.m_7745_(ResourceLocation.m_135820_((String)tag.m_128461_("id")))));
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("has_name", AllItemAttributeTypes.HAS_NAME);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("book_author", AllItemAttributeTypes.BOOK_AUTHOR);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("book_copy", AllItemAttributeTypes.BOOK_COPY);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("astralsorcery_amulet", AllItemAttributeTypes.ASTRAL_AMULET);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("astralsorcery_constellation", AllItemAttributeTypes.ASTRAL_ATTUNMENT);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("astralsorcery_crystal", AllItemAttributeTypes.ASTRAL_CRYSTAL);
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer("astralsorcery_perk_gem", AllItemAttributeTypes.ASTRAL_PERK_GEM);
    }

    private static void createLegacyDeserializer(String nbtKey, ItemAttributeType type) {
        AllItemAttributeLegacyDeserializers.createLegacyDeserializer(nbtKey, (CompoundTag tag) -> {
            ItemAttribute attribute = type.createAttribute();
            attribute.load((CompoundTag)tag);
            return attribute;
        });
    }

    private static void createLegacyDeserializer(final String nbtKey, final Function<CompoundTag, ItemAttribute> func) {
        AllItemAttributeLegacyDeserializers.addLegacyDeserializer(new ItemAttribute.LegacyDeserializer(){

            @Override
            public String getNBTKey() {
                return nbtKey;
            }

            @Override
            public ItemAttribute readNBT(CompoundTag nbt) {
                return (ItemAttribute)func.apply(nbt);
            }
        });
    }

    private static void addLegacyDeserializer(ItemAttribute.LegacyDeserializer legacyDeserializer) {
        ItemAttribute.LegacyDeserializer.ALL.add(legacyDeserializer);
    }
}

