/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungscavebiomes.command;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.yungnickyoung.minecraft.yungscavebiomes.module.TrimPatternsModule;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DebugSpawnArmorTrimsCommand {
    private static final Map<Pair<ArmorMaterial, EquipmentSlot>, Item> MATERIAL_AND_SLOT_TO_ITEM = (Map)Util.m_137469_((Object)Maps.newHashMap(), $$0 -> {
        $$0.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)EquipmentSlot.HEAD), Items.f_42464_);
        $$0.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)EquipmentSlot.CHEST), Items.f_42465_);
        $$0.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)EquipmentSlot.LEGS), Items.f_42466_);
        $$0.put(Pair.of((Object)ArmorMaterials.CHAIN, (Object)EquipmentSlot.FEET), Items.f_42467_);
        $$0.put(Pair.of((Object)ArmorMaterials.IRON, (Object)EquipmentSlot.HEAD), Items.f_42468_);
        $$0.put(Pair.of((Object)ArmorMaterials.IRON, (Object)EquipmentSlot.CHEST), Items.f_42469_);
        $$0.put(Pair.of((Object)ArmorMaterials.IRON, (Object)EquipmentSlot.LEGS), Items.f_42470_);
        $$0.put(Pair.of((Object)ArmorMaterials.IRON, (Object)EquipmentSlot.FEET), Items.f_42471_);
        $$0.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)EquipmentSlot.HEAD), Items.f_42476_);
        $$0.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)EquipmentSlot.CHEST), Items.f_42477_);
        $$0.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)EquipmentSlot.LEGS), Items.f_42478_);
        $$0.put(Pair.of((Object)ArmorMaterials.GOLD, (Object)EquipmentSlot.FEET), Items.f_42479_);
        $$0.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)EquipmentSlot.HEAD), Items.f_42480_);
        $$0.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)EquipmentSlot.CHEST), Items.f_42481_);
        $$0.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)EquipmentSlot.LEGS), Items.f_42482_);
        $$0.put(Pair.of((Object)ArmorMaterials.NETHERITE, (Object)EquipmentSlot.FEET), Items.f_42483_);
        $$0.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)EquipmentSlot.HEAD), Items.f_42472_);
        $$0.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)EquipmentSlot.CHEST), Items.f_42473_);
        $$0.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)EquipmentSlot.LEGS), Items.f_42474_);
        $$0.put(Pair.of((Object)ArmorMaterials.DIAMOND, (Object)EquipmentSlot.FEET), Items.f_42475_);
        $$0.put(Pair.of((Object)ArmorMaterials.TURTLE, (Object)EquipmentSlot.HEAD), Items.f_42354_);
    });
    private static final List<ResourceKey<TrimPattern>> TRIM_PATTERNS = List.of(TrimPatternsModule.ANCIENT);
    private static final List<ResourceKey<TrimMaterial>> TRIM_MATERIALS = List.of(TrimMaterials.f_265905_, TrimMaterials.f_266000_, TrimMaterials.f_265896_, TrimMaterials.f_265870_, TrimMaterials.f_265969_, TrimMaterials.f_265937_, TrimMaterials.f_266071_, TrimMaterials.f_266027_, TrimMaterials.f_265981_, TrimMaterials.f_265872_);
    private static final ToIntFunction<ResourceKey<TrimPattern>> TRIM_PATTERN_ORDER = Util.m_214686_(TRIM_PATTERNS);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> TRIM_MATERIAL_ORDER = Util.m_214686_(TRIM_MATERIALS);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext ctx, Commands.CommandSelection selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ycb_armor_trims").requires(source -> source.m_6761_(2))).executes(context -> DebugSpawnArmorTrimsCommand.spawnArmorTrims((CommandSourceStack)context.getSource(), (Player)((CommandSourceStack)context.getSource()).m_81375_())));
    }

    private static int spawnArmorTrims(CommandSourceStack source, Player player) {
        Level level = player.m_9236_();
        NonNullList armorTrims = NonNullList.m_122779_();
        Registry patternRegistry = level.m_9598_().m_175515_(Registries.f_266063_);
        Registry materialRegistry = level.m_9598_().m_175515_(Registries.f_266076_);
        patternRegistry.m_123024_().filter(pattern -> pattern.f_266052_().m_135827_().equals("yungscavebiomes")).sorted(Comparator.comparing(p -> TRIM_PATTERN_ORDER.applyAsInt((ResourceKey<TrimPattern>)((ResourceKey)patternRegistry.m_7854_(p).orElse(null))))).forEachOrdered(p -> materialRegistry.m_123024_().sorted(Comparator.comparing(m -> TRIM_MATERIAL_ORDER.applyAsInt((ResourceKey<TrimMaterial>)((ResourceKey)materialRegistry.m_7854_(m).orElse(null))))).forEachOrdered(m -> armorTrims.add((Object)new ArmorTrim(materialRegistry.m_263177_(m), patternRegistry.m_263177_(p)))));
        BlockPos pos = player.m_20183_().m_5484_(player.m_6350_(), 5);
        int numMats = ArmorMaterials.values().length - 1;
        double $$8 = 3.0;
        int trimIndex = 0;
        int materialIndex = 0;
        for (ArmorTrim trim : armorTrims) {
            for (ArmorMaterials material : ArmorMaterials.values()) {
                if (material == ArmorMaterials.LEATHER) continue;
                double x = (double)pos.m_123341_() + 0.5 - (double)(trimIndex % materialRegistry.m_13562_()) * 3.0;
                double y = (double)pos.m_123342_() + 0.5 + (double)(materialIndex % numMats) * 3.0;
                double z = (double)pos.m_123343_() + 0.5 + (double)(trimIndex / materialRegistry.m_13562_() * 10);
                ArmorStand armorStand = new ArmorStand(level, x, y, z);
                armorStand.m_146922_(180.0f);
                armorStand.m_20242_(true);
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    ArmorItem $$20;
                    Item armorItem = MATERIAL_AND_SLOT_TO_ITEM.get(Pair.of((Object)material, (Object)slot));
                    if (armorItem == null) continue;
                    ItemStack armorItemStack = new ItemStack((ItemLike)armorItem);
                    ArmorTrim.m_266570_((RegistryAccess)level.m_9598_(), (ItemStack)armorItemStack, (ArmorTrim)trim);
                    armorStand.m_8061_(slot, armorItemStack);
                    if (armorItem instanceof ArmorItem && ($$20 = (ArmorItem)armorItem).m_40401_() == ArmorMaterials.TURTLE) {
                        armorStand.m_6593_((Component)((TrimPattern)trim.m_266429_().m_203334_()).m_266463_(trim.m_266210_()).m_6881_().m_130946_(" ").m_7220_(((TrimMaterial)trim.m_266210_().m_203334_()).f_266021_()));
                        armorStand.m_20340_(true);
                        continue;
                    }
                    armorStand.m_6842_(true);
                }
                level.m_7967_((Entity)armorStand);
                ++materialIndex;
            }
            ++trimIndex;
        }
        source.m_288197_(() -> Component.m_237113_((String)"Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

