/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.impl.key;

import com.mojang.blaze3d.platform.InputConstants;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceLocation;
import nl.enjarai.doabarrelroll.api.key.InputContext;
import nl.enjarai.doabarrelroll.util.key.ContextualKeyBinding;

public final class InputContextImpl
implements InputContext {
    private static final List<InputContextImpl> CONTEXTS = new ReferenceArrayList();
    private final ResourceLocation id;
    private final Supplier<Boolean> activeCondition;
    private final List<KeyMapping> keyBindings = new ReferenceArrayList();
    private final Map<InputConstants.Key, KeyMapping> bindingsByKey = new HashMap<InputConstants.Key, KeyMapping>();
    private boolean active;

    public static List<InputContextImpl> getContexts() {
        return CONTEXTS;
    }

    public static boolean contextsContain(KeyMapping binding) {
        for (InputContextImpl context : InputContextImpl.getContexts()) {
            if (!context.getKeyBindings().contains(binding)) continue;
            return true;
        }
        return false;
    }

    public InputContextImpl(ResourceLocation id, Supplier<Boolean> activeCondition) {
        this.id = id;
        this.activeCondition = activeCondition;
        CONTEXTS.add(this);
    }

    public void tick() {
        boolean active = this.activeCondition.get();
        if (active != this.active) {
            this.active = active;
            KeyMapping.m_90829_();
        }
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void addKeyBinding(KeyMapping keyBinding) {
        Objects.requireNonNull(keyBinding);
        this.keyBindings.add(keyBinding);
        ((ContextualKeyBinding)keyBinding).doABarrelRoll$addToContext(this);
    }

    @Override
    public List<KeyMapping> getKeyBindings() {
        return this.keyBindings;
    }

    @Override
    public KeyMapping getKeyBinding(InputConstants.Key key) {
        return this.bindingsByKey.get(key);
    }

    @Override
    public void updateKeysByCode() {
        this.bindingsByKey.clear();
        for (KeyMapping keyBinding : this.keyBindings) {
            this.bindingsByKey.put(keyBinding.f_90816_, keyBinding);
        }
    }
}

