/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import rbasamoyai.createbigcannons.base.BlockStatePredicateHelper;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.ICannonContraptionType;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountBlockPropertiesProvider;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountBlockPropertiesSerializer;
import rbasamoyai.createbigcannons.cannon_control.config.GeneralMountProperties;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;

public record SimpleBlockMountProperties(GeneralMountProperties defaultProperties, Map<BlockState, GeneralMountProperties> propertiesByState) implements CannonMountBlockPropertiesProvider
{
    @Override
    public float maximumElevation(Level level, BlockState state, BlockPos pos) {
        return this.propertiesByState.getOrDefault(state, this.defaultProperties).maximumElevation();
    }

    @Override
    public float maximumDepression(Level level, BlockState state, BlockPos pos) {
        return this.propertiesByState.getOrDefault(state, this.defaultProperties).maximumDepression();
    }

    public static class Serializer
    implements CannonMountBlockPropertiesSerializer<SimpleBlockMountProperties> {
        @Override
        public SimpleBlockMountProperties fromJson(BlockEntityType<?> beType, ICannonContraptionType contraptionType, JsonObject obj) {
            Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
            for (Block block : beType.f_58915_) {
                ResourceLocation blockLoc = CBCRegistryUtils.getBlockLocation(block);
                String blockKey = blockLoc.toString();
                if (!obj.has(blockKey) && !obj.get(blockKey).isJsonObject()) continue;
                JsonObject variantsOfBlock = obj.getAsJsonObject(blockKey);
                StateDefinition definition = block.m_49965_();
                HashSet blockStates = new HashSet(definition.m_61056_());
                for (String variantKey : variantsOfBlock.keySet()) {
                    Predicate<BlockState> pred = BlockStatePredicateHelper.variantPredicate((StateDefinition<Block, BlockState>)definition, variantKey);
                    JsonElement variantEl = variantsOfBlock.get(variantKey);
                    if (!variantEl.isJsonObject()) {
                        throw new JsonSyntaxException("Invalid info for variant '" + variantKey + "''");
                    }
                    JsonObject variantInfo = variantEl.getAsJsonObject();
                    GeneralMountProperties properties = GeneralMountProperties.fromJson(variantInfo);
                    Iterator stateIter = blockStates.iterator();
                    while (stateIter.hasNext()) {
                        BlockState state = (BlockState)stateIter.next();
                        if (!pred.test(state)) continue;
                        propertiesByState.put(state, properties);
                        stateIter.remove();
                    }
                }
            }
            GeneralMountProperties defaultProperties = GeneralMountProperties.fromJson(obj);
            return new SimpleBlockMountProperties(defaultProperties, (Map<BlockState, GeneralMountProperties>)propertiesByState);
        }

        @Override
        public void toNetwork(SimpleBlockMountProperties properties, FriendlyByteBuf buf) {
            properties.defaultProperties.toNetwork(buf);
            buf.m_130130_(properties.propertiesByState.size());
            for (Map.Entry<BlockState, GeneralMountProperties> entry : properties.propertiesByState.entrySet()) {
                buf.m_130130_(Block.m_49956_((BlockState)entry.getKey()));
                entry.getValue().toNetwork(buf);
            }
        }

        @Override
        public SimpleBlockMountProperties fromNetwork(FriendlyByteBuf buf) {
            GeneralMountProperties defaultProperties = GeneralMountProperties.fromNetwork(buf);
            int sz = buf.m_130242_();
            Reference2ObjectOpenHashMap propertiesByState = new Reference2ObjectOpenHashMap();
            for (int i = 0; i < sz; ++i) {
                BlockState state = Block.m_49803_((int)buf.m_130242_());
                GeneralMountProperties properties = GeneralMountProperties.fromNetwork(buf);
                propertiesByState.put(state, properties);
            }
            return new SimpleBlockMountProperties(defaultProperties, (Map<BlockState, GeneralMountProperties>)propertiesByState);
        }
    }
}

