/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.networking.NetworkManager;

public class CommandWrapper
implements CommandSource,
Consumer<Component> {
    CommandContext<CommandSourceStack> source;

    public CommandWrapper(CommandContext<CommandSourceStack> source) {
        this.source = source;
    }

    public boolean hasValue(String id, Class<?> type) {
        try {
            return this.source.getArgument(id, type) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T> T getOrDefault(String id, Class<T> type, T defaultValue) {
        try {
            return (T)this.source.getArgument(id, type);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public <T> T get(String id, Class<T> type) {
        return (T)this.source.getArgument(id, type);
    }

    public ResourceKey<Level> getDimension(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)this.getOrDefault(id, ResourceLocation.class, this.getSource().m_81372_().m_46472_().m_135782_()));
    }

    public void sendErrorMessage(Component component) {
        if (this.source != null) {
            ((CommandSourceStack)this.source.getSource()).m_81352_(this.ensureReadable(component));
        }
    }

    public void sendFeedBackMessage(Component component) {
        if (this.source != null) {
            ((CommandSourceStack)this.source.getSource()).m_288197_(() -> this.ensureReadable(component), true);
        }
    }

    public CommandContext<CommandSourceStack> getContext() {
        return this.source;
    }

    public CommandSourceStack getSource() {
        return (CommandSourceStack)this.source.getSource();
    }

    public UUID getSenderId() {
        Entity entity = this.getSource().m_81373_();
        return entity instanceof Player ? entity.m_20148_() : null;
    }

    public String getTextName() {
        return this.getSource().m_81368_();
    }

    public Component getName() {
        return this.getSource().m_81357_();
    }

    private Component ensureReadable(Component comp) {
        return this.getSource().m_230897_() && !NetworkManager.INSTANCE.isInstalledOnClient(this.getSource().m_230896_()) ? TextUtil.serverTranslate(comp) : comp;
    }

    @Override
    public void accept(Component t) {
        this.m_213846_(t);
    }

    public void m_213846_(Component component) {
        if (this.source == null) {
            return;
        }
        ((CommandSourceStack)this.source.getSource()).m_288197_(() -> this.ensureReadable(component), true);
    }

    public boolean m_6999_() {
        return true;
    }

    public boolean m_7028_() {
        return true;
    }

    public boolean m_6102_() {
        return true;
    }
}

