/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker.types;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import pregenerator.base.mixins.common.chunk.ChunkHolderMixin;
import pregenerator.base.mixins.common.storage.ChunkManagerMixin;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.tracker.types.BaseWorldEntry;
import pregenerator.common.tracker.types.IWorldEntry;

public class TileEntry
extends BaseWorldEntry {
    int blockId;
    boolean isTicking;

    public TileEntry(BlockEntityType<?> type, int count, Block block, boolean isTicking) {
        this(TileEntry.getId(ForgeRegistries.BLOCK_ENTITY_TYPES, type), count, TileEntry.getId(ForgeRegistries.BLOCKS, block), isTicking);
    }

    public TileEntry(int id, int count, int blockId, boolean isTicking) {
        super(id, count);
        this.blockId = blockId;
        this.isTicking = isTicking;
    }

    public TileEntry(FriendlyByteBuf buffer) {
        super(buffer);
        this.blockId = buffer.m_130242_();
        this.isTicking = buffer.readBoolean();
    }

    public boolean isTicking() {
        return this.isTicking;
    }

    public Block getType() {
        return (Block)((ForgeRegistry)ForgeRegistries.BLOCKS).getValue(this.blockId);
    }

    @Override
    protected ResourceLocation getKey(int id, RegistryAccess registry) {
        return ((ForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES).getKey(id).m_135782_();
    }

    @Override
    public Component getName(RegistryAccess registry) {
        return this.getType().m_49954_();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.m_130130_(this.blockId);
        buffer.writeBoolean(this.isTicking);
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return true;
    }

    @Override
    public int deleteWorld(WorldTracker tracker, Player player) {
        BlockEntityType type = (BlockEntityType)((ForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES).getValue(this.id);
        if (type == null) {
            return 0;
        }
        ObjectArrayList entities = new ObjectArrayList(this.count);
        TileEntry.getBlockEntities(tracker.getWorld(), arg_0 -> TileEntry.lambda$deleteWorld$0(type, (List)entities, arg_0));
        entities.forEach(T -> tracker.getWorld().m_7471_(T.m_58899_(), false));
        return entities.size();
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        LevelChunk chunk = tracker.getChunk(position);
        if (chunk == null) {
            return 0;
        }
        BlockEntityType type = (BlockEntityType)((ForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES).getValue(this.id);
        if (type == null) {
            return 0;
        }
        ObjectArrayList entities = new ObjectArrayList(chunk.m_62954_().values());
        entities.removeIf(T -> T.m_58903_() != type);
        entities.forEach(T -> tracker.getWorld().m_7471_(T.m_58899_(), false));
        return entities.size();
    }

    public static List<IWorldEntry> getLevel(ServerLevel level) {
        Object2ObjectLinkedOpenHashMap typeMap = new Object2ObjectLinkedOpenHashMap();
        ObjectOpenHashSet ticking = new ObjectOpenHashSet();
        BaseWorldEntry.Counter<BlockEntityType> counter = new BaseWorldEntry.Counter<BlockEntityType>();
        TileEntry.getBlockEntities(level, arg_0 -> TileEntry.lambda$getLevel$4((Map)typeMap, counter, level, (Set)ticking, arg_0));
        return counter.map((arg_0, arg_1) -> TileEntry.lambda$getLevel$5((Map)typeMap, (Set)ticking, arg_0, arg_1));
    }

    public static List<IWorldEntry> getChunk(LevelChunk chunk) {
        Object2ObjectLinkedOpenHashMap typeMap = new Object2ObjectLinkedOpenHashMap();
        ObjectOpenHashSet ticking = new ObjectOpenHashSet();
        BaseWorldEntry.Counter<BlockEntityType> counter = new BaseWorldEntry.Counter<BlockEntityType>();
        for (BlockEntity entity : chunk.m_62954_().values()) {
            typeMap.putIfAbsent(entity.m_58903_(), entity.m_58900_().m_60734_());
            counter.add(entity.m_58903_());
            if (entity.m_58900_().m_155944_(chunk.m_62953_(), entity.m_58903_()) == null) continue;
            ticking.add(entity.m_58903_());
        }
        return counter.map((arg_0, arg_1) -> TileEntry.lambda$getChunk$6((Map)typeMap, (Set)ticking, arg_0, arg_1));
    }

    public static void getBlockEntities(ServerLevel level, Consumer<BlockEntity> result) {
        for (ChunkHolder holder : ((ChunkManagerMixin)level.m_7726_().f_8325_).getLoadedChunks()) {
            ChunkHolderMixin mixin = (ChunkHolderMixin)holder;
            LevelChunk chunk = mixin.getLoadingChunk();
            if (chunk == null) {
                ChunkAccess testChunk;
                Either either = holder.m_140080_(ChunkStatus.f_62326_).getNow(null);
                if (either == null || !((testChunk = (ChunkAccess)either.left().orElse(null)) instanceof LevelChunk)) continue;
                chunk = (LevelChunk)testChunk;
            }
            chunk.m_62954_().values().forEach(result);
        }
    }

    private static /* synthetic */ IWorldEntry lambda$getChunk$6(Map typeMap, Set ticking, BlockEntityType T, int C) {
        return new TileEntry(T, C, (Block)typeMap.get(T), ticking.contains(T));
    }

    private static /* synthetic */ IWorldEntry lambda$getLevel$5(Map typeMap, Set ticking, BlockEntityType T, int C) {
        return new TileEntry(T, C, (Block)typeMap.get(T), ticking.contains(T));
    }

    private static /* synthetic */ void lambda$getLevel$4(Map typeMap, BaseWorldEntry.Counter counter, ServerLevel level, Set ticking, BlockEntity T) {
        typeMap.putIfAbsent(T.m_58903_(), T.m_58900_().m_60734_());
        counter.add(T.m_58903_());
        if (T.m_58900_().m_155944_((Level)level, T.m_58903_()) != null) {
            ticking.add(T.m_58903_());
        }
    }

    private static /* synthetic */ void lambda$deleteWorld$0(BlockEntityType type, List entities, BlockEntity T) {
        if (T.m_58903_() != type) {
            return;
        }
        entities.add(T);
    }
}

