/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker.types;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import pregenerator.base.api.TextUtil;
import pregenerator.common.base.IMiniTask;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.ProgressPacket;
import pregenerator.common.tracker.ServerTracker;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.tracker.types.BaseWorldEntry;
import pregenerator.common.tracker.types.IWorldEntry;

public class BlockEntry
extends BaseWorldEntry {
    public BlockEntry(FriendlyByteBuf buf) {
        super(buf);
    }

    public BlockEntry(Block block, int count) {
        super(BlockEntry.getId(ForgeRegistries.BLOCKS, block), count);
    }

    public BlockEntry(int id, int count) {
        super(id, count);
    }

    public boolean isTicking() {
        return this.getType().m_49966_().m_60823_();
    }

    public Block getType() {
        return (Block)((ForgeRegistry)ForgeRegistries.BLOCKS).getValue(this.id);
    }

    @Override
    protected ResourceLocation getKey(int id, RegistryAccess registry) {
        return ((ForgeRegistry)ForgeRegistries.BLOCKS).getKey(id).m_135782_();
    }

    @Override
    public Component getName(RegistryAccess registry) {
        return this.getType().m_49954_();
    }

    public static List<IWorldEntry> getLevel(ServerLevel level) {
        return FetchBlocks.fetch(ServerTracker.INSTANCE.getWorldTracker((ResourceKey<Level>)level.m_46472_()));
    }

    public static List<IWorldEntry> getChunk(LevelChunk chunk) {
        BaseWorldEntry.Counter<Block> counter = BlockEntry.countBlocks(chunk);
        counter.remove(T -> T.m_49966_().m_60795_());
        return counter.map(BlockEntry::new);
    }

    private static BaseWorldEntry.Counter<Block> countBlocks(LevelChunk chunk) {
        BaseWorldEntry.Counter<Block> counter = new BaseWorldEntry.Counter<Block>();
        for (LevelChunkSection section : chunk.m_7103_()) {
            section.m_63019_().m_63099_((T, C) -> counter.add(T.m_60734_(), C));
        }
        return counter;
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return true;
    }

    @Override
    public int deleteWorld(WorldTracker tracker, Player player) {
        if (this.getCount() >= 100000) {
            UUID taskId = UUID.randomUUID();
            LongArrayList list = new LongArrayList();
            for (LevelChunk chunk : tracker.getChunks()) {
                list.add(chunk.m_7697_().m_45588_());
            }
            NetworkManager.INSTANCE.sendToPlayer(new ProgressPacket.Start(this.getCount(), taskId, (Component)TextUtil.literal("Deleting Blocks")), player);
            ServerManager.INSTANCE.startMiniTask(taskId, new DeletionTask(tracker, (LongList)list, player, this.getType(), this.getCount()));
            return this.getCount();
        }
        int count = 0;
        Block block = this.getType();
        for (LevelChunk chunk : tracker.getChunks()) {
            int xOff = chunk.m_7697_().f_45578_ << 4;
            int zOff = chunk.m_7697_().f_45579_ << 4;
            LevelChunkSection[] sections = chunk.m_7103_();
            for (int y = sections.length - 1; y >= 0; --y) {
                LevelChunkSection section = sections[y];
                if (section.m_188008_() || !section.m_63002_(T -> T.m_60713_(block))) continue;
                for (int i = 0; i < 4096; ++i) {
                    BlockPos pos = new BlockPos(i % 16 + xOff, i / 16 % 16 + SectionPos.m_123223_((int)chunk.m_151568_(y)), i / 256 + zOff);
                    if (!chunk.m_8055_(pos).m_60713_(block)) continue;
                    tracker.getWorld().m_46597_(pos, Blocks.f_50016_.m_49966_());
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        LevelChunk chunk = tracker.getChunk(position);
        if (chunk == null) {
            return 0;
        }
        int xOff = ChunkPos.m_45592_((long)position) << 4;
        int zOff = ChunkPos.m_45602_((long)position) << 4;
        Block block = this.getType();
        int count = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int m = chunk.m_7103_().length;
        for (int index = 0; index < m; ++index) {
            LevelChunkSection section = chunk.m_183278_(index);
            if (section.m_188008_() || !section.m_63002_(T -> T.m_60713_(block))) continue;
            for (int i = 0; i < 4096; ++i) {
                int x = i % 16;
                int y = i / 16 % 16;
                int z = i / 256;
                if (!section.m_62982_(x, y, z).m_60713_(block)) continue;
                tracker.getWorld().m_7471_((BlockPos)pos.m_122178_(x + xOff, y + SectionPos.m_123223_((int)chunk.m_151568_(index)), z + zOff), false);
                ++count;
            }
        }
        return count;
    }

    private static class FetchBlocks
    extends RecursiveAction {
        private static final long serialVersionUID = 7982665640808749376L;
        WorldTracker tracker;
        List<IWorldEntry> result = new ObjectArrayList();

        private FetchBlocks(WorldTracker tracker) {
            this.tracker = tracker;
        }

        @Override
        protected void compute() {
            ObjectArrayList tasks = new ObjectArrayList();
            for (LevelChunk chunk : this.tracker.getChunks()) {
                tasks.add(ForkJoinTask.adapt(() -> BlockEntry.countBlocks(chunk)));
            }
            FetchBlocks.invokeAll(tasks);
            BaseWorldEntry.Counter<Block> globalCounter = new BaseWorldEntry.Counter<Block>();
            for (ForkJoinTask entry : tasks) {
                globalCounter.merge((BaseWorldEntry.Counter)entry.getRawResult());
            }
            globalCounter.remove(T -> T.m_49966_().m_60795_());
            this.result = globalCounter.map(BlockEntry::new);
        }

        public static List<IWorldEntry> fetch(WorldTracker tracker) {
            FetchBlocks task = new FetchBlocks(tracker);
            ForkJoinPool.commonPool().invoke(task);
            task.quietlyJoin();
            return task.result;
        }
    }

    public static class DeletionTask
    implements IMiniTask {
        WorldTracker tracker;
        LongList chunks;
        Player owner;
        Block block;
        int index = 0;
        long current;
        long max;

        public DeletionTask(WorldTracker tracker, LongList chunks, Player owner, Block block, long max) {
            this.tracker = tracker;
            this.chunks = chunks;
            this.owner = owner;
            this.block = block;
            this.max = max;
        }

        @Override
        public void interrupt() {
            NetworkManager.INSTANCE.sendToPlayer(new ProgressPacket.Complete(), this.owner);
        }

        @Override
        public boolean update(long startTime) {
            while (System.currentTimeMillis() - startTime < 100L && this.index < this.chunks.size()) {
                long position = this.chunks.getLong(this.index);
                LevelChunk chunk = this.tracker.getChunk(position);
                if (chunk != null) {
                    int xOff = chunk.m_7697_().f_45578_ << 4;
                    int zOff = chunk.m_7697_().f_45579_ << 4;
                    LevelChunkSection[] sections = chunk.m_7103_();
                    for (int y = sections.length - 1; y >= 0; --y) {
                        LevelChunkSection section = sections[y];
                        if (section.m_188008_() || !section.m_63002_(T -> T.m_60713_(this.block))) continue;
                        for (int i = 0; i < 4096; ++i) {
                            BlockPos pos = new BlockPos(i % 16 + xOff, i / 16 % 16 + SectionPos.m_123223_((int)chunk.m_151568_(y)), i / 256 + zOff);
                            if (!chunk.m_8055_(pos).m_60713_(this.block)) continue;
                            this.tracker.getWorld().m_46597_(pos, Blocks.f_50016_.m_49966_());
                            ++this.current;
                        }
                    }
                }
                ++this.index;
                NetworkManager.INSTANCE.sendToPlayer(new ProgressPacket.Update(this.current, this.max), this.owner);
            }
            if (this.index >= this.chunks.size()) {
                NetworkManager.INSTANCE.sendToPlayer(new ProgressPacket.Complete(), this.owner);
                return false;
            }
            return true;
        }

        @Override
        public boolean hasClientOverlay() {
            return false;
        }

        @Override
        public byte getClientDataId() {
            return 0;
        }

        @Override
        public void writeData(FriendlyByteBuf buffer) {
        }
    }
}

