/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker.types;

import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import pregenerator.common.tracker.WorldTracker;
import pregenerator.common.tracker.types.BaseWorldEntry;
import pregenerator.common.tracker.types.IWorldEntry;

public class BiomeEntry
extends BaseWorldEntry {
    public BiomeEntry(FriendlyByteBuf buf) {
        super(buf);
    }

    public BiomeEntry(int id, int count) {
        super(id, count);
    }

    @Override
    protected ResourceLocation getKey(int id, RegistryAccess registry) {
        Registry subRegistry = registry.m_175515_(Registries.f_256952_);
        return subRegistry.m_7981_((Object)((Biome)subRegistry.m_7942_(id)));
    }

    public static List<IWorldEntry> getChunk(LevelChunk chunk) {
        Level level = chunk.m_62953_();
        if (level instanceof ServerLevel) {
            BaseWorldEntry.Counter<Holder> counter = new BaseWorldEntry.Counter<Holder>();
            for (LevelChunkSection section : chunk.m_7103_()) {
                section.m_187996_().m_63099_(counter::add);
            }
            IdMap biome = ((ServerLevel)level).m_9598_().m_175515_(Registries.f_256952_).m_206115_();
            return counter.map((T, C) -> new BiomeEntry(biome.m_7447_(T), C));
        }
        return ObjectLists.emptyList();
    }

    @Override
    public boolean canDelete(boolean chunk) {
        return false;
    }

    @Override
    public int deleteWorld(WorldTracker tacker, Player player) {
        return 0;
    }

    @Override
    public int deleteChunk(WorldTracker tracker, long position) {
        return 0;
    }
}

