/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.saveddata.SavedData;
import pregenerator.common.structures.StructureRef;
import pregenerator.common.structures.StructureTracker;

public class StructureWorld
extends SavedData {
    static final String DATA = "pregen_structure_cache";
    Map<ResourceLocation, StructureTracker> trackers = new Object2ObjectLinkedOpenHashMap();

    public static StructureWorld getStructures(ServerLevel world) {
        return (StructureWorld)world.m_8895_().m_164861_(StructureWorld::loadData, StructureWorld::new, DATA);
    }

    public static StructureWorld loadData(CompoundTag nbt) {
        StructureWorld world = new StructureWorld();
        world.load(nbt);
        return world;
    }

    public void load(CompoundTag nbt) {
        ListTag list = nbt.m_128437_("data", 10);
        int m = list.size();
        for (int i = 0; i < m; ++i) {
            StructureTracker tracker = new StructureTracker(list.m_128728_(i));
            this.trackers.put(tracker.getName(), tracker);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        for (StructureTracker tracker : this.trackers.values()) {
            list.add((Object)tracker.write());
        }
        compound.m_128365_("data", (Tag)list);
        return compound;
    }

    public void addStructure(ResourceLocation name, StructureStart start) {
        if (start == StructureStart.f_73561_ || start == null) {
            return;
        }
        StructureTracker tracker = this.trackers.get(name);
        if (tracker == null) {
            tracker = new StructureTracker(name);
            this.trackers.put(name, tracker);
        }
        tracker.addStructure(start);
        this.m_77762_();
    }

    public void getStructures(ResourceLocation name, Collection<StructureRef> refs) {
        if (name == null) {
            for (StructureTracker tracker : this.trackers.values()) {
                refs.addAll(tracker.getReferences());
            }
            return;
        }
        StructureTracker tracker = this.trackers.get(name);
        if (tracker != null) {
            refs.addAll(tracker.getReferences());
        }
    }
}

