/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.structures;

import com.google.common.base.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import pregenerator.base.api.TextUtil;

public class StructureRef {
    ResourceLocation id;
    long pos;
    int components;
    int size;
    int[] bounds;

    public StructureRef(ResourceLocation id, StructureStart start) {
        this.id = id;
        this.pos = start.m_163625_().m_45588_();
        this.components = start.m_73602_().size();
        BoundingBox box = start.m_73601_();
        this.bounds = new int[]{box.m_162395_(), box.m_162396_(), box.m_162398_(), box.m_162399_(), box.m_162400_(), box.m_162401_()};
        this.size = this.calculateChunkSize();
    }

    public StructureRef(ResourceLocation name, int[] data) {
        this.id = name;
        this.pos = ChunkPos.m_45589_((int)data[0], (int)data[1]);
        this.components = data[2];
        this.size = data[3];
        this.bounds = new int[6];
        for (int i = 0; i < 6; ++i) {
            this.bounds[i] = data[4 + i];
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.pos});
    }

    public boolean equals(Object obj) {
        if (obj instanceof StructureRef) {
            return ((StructureRef)obj).pos == this.pos;
        }
        return false;
    }

    public int[] write() {
        int[] index = new int[10];
        index[0] = ChunkPos.m_45592_((long)this.pos);
        index[1] = ChunkPos.m_45602_((long)this.pos);
        index[2] = this.components;
        index[3] = this.size;
        for (int i = 0; i < 6; ++i) {
            index[4 + i] = this.bounds[i];
        }
        return index;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public Component getDisplayName() {
        MutableComponent mod = TextUtil.translate("gui.chunk_pregen.biome_preview.tooltip.structure_mod", TextUtil.getModName(this.id.m_135827_())).m_130940_(ChatFormatting.GOLD);
        return TextUtil.translate("gui.chunk_pregen.biome_preview.tooltip.structure_name", TextUtil.literalPascal(this.id.m_135815_()), mod).m_130940_(ChatFormatting.BLUE);
    }

    public int[] getBounds() {
        return this.bounds;
    }

    public int getSize() {
        return this.size;
    }

    private int calculateChunkSize() {
        int width = this.bounds[3] - this.bounds[0];
        int depth = this.bounds[5] - this.bounds[2];
        return (int)Math.sqrt(width * width + depth * depth);
    }
}

