/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.manager;

import com.google.common.base.Supplier;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayFIFOQueue;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.base.IBaseTask;
import pregenerator.common.base.IInteruptable;
import pregenerator.common.base.SimpleTaskStorage;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;
import pregenerator.common.manager.ServerManager;

public class TaskQueue<K extends IInteruptable, T extends IBaseTask<K>, P extends IProcess<K, T>> {
    Class<P> clz;
    boolean loadWorld;
    int size;
    PriorityQueue<P> generators = new ObjectArrayFIFOQueue();
    Map<ResourceKey<Level>, IProcess<?, ?>> process;
    Supplier<SimpleTaskStorage<T>> storageProvider;

    public TaskQueue(boolean loadWorld, Class<P> clz, Map<ResourceKey<Level>, IProcess<?, ?>> process, Supplier<SimpleTaskStorage<T>> storageProvider) {
        this.loadWorld = loadWorld;
        this.process = process;
        this.clz = clz;
        this.storageProvider = storageProvider;
    }

    public void populate(int size, Supplier<P> creator) {
        this.size = size;
        for (int i = 0; i < size; ++i) {
            this.generators.enqueue((Object)((IProcess)creator.get()));
        }
    }

    public boolean isEmpty() {
        return this.generators.isEmpty();
    }

    public List<T> getTasks() {
        return ((SimpleTaskStorage)this.storageProvider.get()).getTaskEntries();
    }

    public void consume(Object entry) {
        if (this.clz.isInstance(entry)) {
            this.generators.enqueue((Object)((IProcess)this.clz.cast(entry)));
        }
    }

    public int removeTasks(String name) {
        SimpleTaskStorage storage = (SimpleTaskStorage)this.storageProvider.get();
        if (name != null && storage.removeTask(name)) {
            return 1;
        }
        if (name == null) {
            int size = storage.size();
            storage.clear();
            return size;
        }
        return 0;
    }

    public boolean storeTask(T task, Consumer<Component> listener, MinecraftServer server) {
        if (task == null) {
            listener.accept((Component)TextUtil.impossibleScenario());
            return false;
        }
        SimpleTaskStorage storage = (SimpleTaskStorage)this.storageProvider.get();
        if (!storage.addTask(task)) {
            listener.accept((Component)TextUtil.translate("queue.chunk_pregen.errors.already_exists", task.getName()).m_130940_(ChatFormatting.GOLD));
            return false;
        }
        return true;
    }

    public boolean startTask(T task, Consumer<Component> listener, MinecraftServer server) {
        if (task == null) {
            listener.accept((Component)TextUtil.impossibleScenario());
            return false;
        }
        SimpleTaskStorage storage = (SimpleTaskStorage)this.storageProvider.get();
        if (!storage.addTask(task)) {
            listener.accept((Component)TextUtil.translate("queue.chunk_pregen.errors.already_exists", task.getName()).m_130940_(ChatFormatting.GOLD));
            return false;
        }
        if (this.generators.isEmpty()) {
            listener.accept((Component)TextUtil.translateStyled("queue.chunk_pregen.errors.no_processors", ChatFormatting.AQUA));
            return false;
        }
        if (this.process.containsKey(task.getDimension())) {
            listener.accept((Component)TextUtil.translateStyled("queue.chunk_pregen.errors.dimension_busy", ChatFormatting.AQUA));
            return false;
        }
        IProcess processor = (IProcess)this.generators.dequeue();
        this.process.put(task.getDimension(), processor);
        IProcess.PrepareProgress progress = new IProcess.PrepareProgress();
        processor.prepaireTask(progress, task.getName());
        this.validateTask(task, progress, server);
        storage.startTask(task.getName());
        task.createTask(server.m_129880_(task.getDimension()), Util.m_183991_(), progress).thenAcceptAsync(T -> {
            if (processor.startTask(task, T)) {
                listener.accept((Component)TextUtil.translate("queue.chunk_pregen.starting", task.getName()));
                return;
            }
            T.interrupt();
            storage.removeTask(task.getName());
            listener.accept((Component)TextUtil.translate("queue.chunk_pregen.interrupted", task.getName()));
            ServerManager.INSTANCE.onTaskFinished(task.getDimension());
        }, (Executor)server);
        listener.accept((Component)TextUtil.translate("queue.chunk_pregen.preparing", task.getName()));
        return true;
    }

    public boolean continueTask(String name, Consumer<Component> listener, MinecraftServer server) {
        if (this.generators.isEmpty() || this.process.size() >= this.size) {
            return false;
        }
        SimpleTaskStorage storage = (SimpleTaskStorage)this.storageProvider.get();
        Object task = storage.getTask(name);
        if (task == null) {
            return false;
        }
        if (this.process.containsKey(task.getDimension())) {
            return false;
        }
        IProcess processor = (IProcess)this.generators.dequeue();
        this.process.put(task.getDimension(), processor);
        IProcess.PrepareProgress progress = new IProcess.PrepareProgress();
        processor.prepaireTask(progress, task.getName());
        this.validateTask(task, progress, server);
        storage.startTask(name);
        task.createTask(server.m_129880_(task.getDimension()), Util.m_183991_(), progress).thenAcceptAsync(T -> {
            if (processor.startTask(task, T)) {
                listener.accept((Component)TextUtil.translate("queue.chunk_pregen.starting", task.getName()));
                return;
            }
            T.interrupt();
            storage.removeTask(task.getName());
            listener.accept((Component)TextUtil.translate("queue.chunk_pregen.interrupted", task.getName()));
            ServerManager.INSTANCE.onTaskFinished(task.getDimension());
        }, (Executor)server);
        listener.accept((Component)TextUtil.translate("queue.chunk_pregen.preparing", task.getName()));
        return true;
    }

    public boolean findNextTask(Consumer<Component> listener, MinecraftServer server, boolean ignoreFailLog) {
        if (this.generators.isEmpty()) {
            if (!ignoreFailLog) {
                listener.accept((Component)TextUtil.translateStyled("queue.chunk_pregen.errors.continue.no_processors", ChatFormatting.RED));
            }
            return false;
        }
        if (this.process.size() >= this.size) {
            if (!ignoreFailLog) {
                listener.accept((Component)TextUtil.translateStyled("queue.chunk_pregen.errors.continue.no_space", ChatFormatting.RED));
            }
            return false;
        }
        SimpleTaskStorage storage = (SimpleTaskStorage)this.storageProvider.get();
        Object task = storage.getNextTask(this.process.keySet());
        if (task == null) {
            if (!ignoreFailLog) {
                listener.accept((Component)TextUtil.translateStyled("queue.chunk_pregen.errors.continue.no_task", ChatFormatting.RED));
            }
            return false;
        }
        if (this.process.containsKey(task.getDimension())) {
            if (!ignoreFailLog) {
                listener.accept((Component)TextUtil.translate("queue.chunk_pregen.errors.continue.no_dimension", TextUtil.dimension(task.getDimension())).m_130940_(ChatFormatting.RED));
            }
            return false;
        }
        IProcess processor = (IProcess)this.generators.dequeue();
        this.process.put(task.getDimension(), processor);
        IProcess.PrepareProgress progress = new IProcess.PrepareProgress();
        processor.prepaireTask(progress, task.getName());
        this.validateTask(task, progress, server);
        storage.startTask(task.getName());
        task.createTask(server.m_129880_(task.getDimension()), Util.m_183991_(), progress).thenAcceptAsync(T -> {
            if (processor.startTask(task, T)) {
                listener.accept((Component)TextUtil.translate("queue.chunk_pregen.starting", task.getName()));
                return;
            }
            T.interrupt();
            storage.removeTask(task.getName());
            listener.accept((Component)TextUtil.translate("queue.chunk_pregen.interrupted", task.getName()));
            ServerManager.INSTANCE.onTaskFinished(task.getDimension());
        }, (Executor)server);
        listener.accept((Component)TextUtil.translate("queue.chunk_pregen.preparing", task.getName()));
        return true;
    }

    protected void validateTask(T task, IProcess.PrepareProgress progress, MinecraftServer server) {
        ITask gen;
        if (task instanceof ITask && (gen = (ITask)task).getTaskSize() > 1000000L) {
            progress.interruptTask();
        }
    }
}

