/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.IProcess;

public class CircleExpansionTask
extends BaseTask {
    long center;
    int minRadius;
    int maxRadius;

    public CircleExpansionTask(CompoundTag nbt) {
        super(nbt);
        this.center = nbt.m_128454_("center");
        this.minRadius = nbt.m_128451_("min_radius");
        this.maxRadius = nbt.m_128451_("max_radius");
    }

    public CircleExpansionTask(String name, ResourceKey<Level> type, int genType, ChunkPos center, int minRadius, int maxRadius) {
        super(name, type, genType);
        this.center = center.m_45588_();
        this.minRadius = minRadius;
        this.maxRadius = maxRadius;
    }

    @Override
    public byte getId() {
        return 4;
    }

    @Override
    public Component getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.circle_expansion");
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(this.center);
    }

    @Override
    public int getMaxRadius() {
        return this.maxRadius;
    }

    @Override
    public void append(MutableComponent builder) {
        ChunkPos center = new ChunkPos(this.center);
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.circle_expansion"), builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.x_coord", center.f_45578_, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.z_coord", center.f_45579_, builder, ChatFormatting.YELLOW);
        ITask.insert("task.chunk_pregen.min_radius", this.minRadius, builder, ChatFormatting.BLUE);
        ITask.insert("task.chunk_pregen.max_radius", this.maxRadius, builder, ChatFormatting.BLUE);
    }

    @Override
    public long getTaskSize() {
        return (long)((double)(this.maxRadius * this.maxRadius) * Math.PI - (double)(this.minRadius * this.minRadius) * Math.PI);
    }

    @Override
    public ChunkProcess createTask(ServerLevel world, IProcess.PrepareProgress progress) {
        long diameter = (long)this.maxRadius * 2L;
        progress.setMax(diameter * diameter);
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        ChunkPos center = new ChunkPos(this.center);
        process.init(ChunkShapeBuilder.getCircleExpansionShape(center.f_45578_, center.f_45579_, this.minRadius, this.maxRadius, progress), center, this.name, this.task, this.throwEvents, progress);
        return process;
    }
}

