/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.minitasks;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.base.api.TextUtil;
import pregenerator.common.deleter.tasks.DeletionSpecific;
import pregenerator.common.generator.minitasks.BaseChunkScanTask;
import pregenerator.common.manager.ServerManager;

public class CorruptionScan
extends BaseChunkScanTask<Long> {
    LongSet values = LongSets.synchronize((LongSet)new LongLinkedOpenHashSet());
    int lastFive = 0;

    public CorruptionScan(ResourceKey<Level> dimension, UUID source) {
        super(dimension, source);
    }

    @Override
    public boolean hasClientOverlay() {
        return true;
    }

    @Override
    public byte getClientDataId() {
        return 4;
    }

    @Override
    public void writeData(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.dimension.m_135782_());
        buffer.m_130130_(this.filesScanned);
        buffer.m_130130_(this.totalFiles);
        buffer.writeLong((long)this.chunksScanned);
        buffer.writeLong((long)this.totalChunks);
        buffer.m_130130_(this.values.size());
    }

    @Override
    protected void test(CompoundTag tag, Consumer<Long> output) {
    }

    @Override
    protected void onFailure(ChunkPos pos, Consumer<Long> output) {
        output.accept(pos.m_45588_());
    }

    @Override
    protected void onInit() {
    }

    @Override
    protected void onProgressReached(int progress) {
        if (progress - this.lastFive >= 5) {
            this.lastFive = progress;
            this.sendMessage((Component)TextUtil.translate("mini_task.chunk_pregen.age_scan.progress", TextUtil.NUMBERS.format(progress)).m_130940_(ChatFormatting.AQUA));
        }
    }

    @Override
    protected void processResult(List<Long> data) {
        this.values.addAll(data);
    }

    @Override
    protected void onCompletion() {
        if (this.values.isEmpty()) {
            this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.corrupt_scan.none_found"));
            return;
        }
        this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.corrupt_scan.found", this.values.size()));
        Long2ObjectLinkedOpenHashMap regionMapped = new Long2ObjectLinkedOpenHashMap();
        LongIterator iter = this.values.iterator();
        while (iter.hasNext()) {
            long value = iter.nextLong();
            ((LongList)regionMapped.computeIfAbsent(ChunkPos.m_45589_((int)(ChunkPos.m_45592_((long)value) >> 5), (int)(ChunkPos.m_45602_((long)value) >> 5)), T -> new LongArrayList())).add(value);
        }
        for (Long2ObjectMap.Entry entry : regionMapped.long2ObjectEntrySet()) {
            long pos = entry.getLongKey();
            LongList list = (LongList)entry.getValue();
            this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.corrupt_scan.region", TextUtil.NUMBERS.format(list.size()), ChunkPos.m_45592_((long)pos), ChunkPos.m_45602_((long)pos)));
            LongListIterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                long value = iter2.nextLong();
                this.sendForceMessage((Component)TextUtil.translate("mini_task.chunk_pregen.corrupt_scan.chunk", ChunkPos.m_45592_((long)value), ChunkPos.m_45602_((long)value), ChunkPos.m_45592_((long)value) & 0xF, ChunkPos.m_45602_((long)value) & 0xF));
            }
            this.sendForceMessage((Component)TextUtil.empty());
        }
        if (ServerManager.INSTANCE.deletion.storeTask(new DeletionSpecific("corrupt_deletion", (ResourceKey<Level>)this.dimension, (LongList)new LongArrayList((LongCollection)this.values)), this::sendForceMessage, ServerLifecycleHooks.getCurrentServer())) {
            this.sendForceMessage((Component)TextUtil.translateStyled("mini_task.chunk_pregen.corrupt_scan.task", ChatFormatting.GREEN).m_130948_(this.createStyle()));
        }
    }

    private Style createStyle() {
        return Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/pregen continue corrupt_deletion")).m_131162_(Boolean.valueOf(true));
    }
}

