/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.minitasks;

import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.common.base.IMiniTask;
import pregenerator.common.base.ProcessListener;
import pregenerator.common.manager.ServerManager;

public abstract class BaseScanTask
implements IMiniTask {
    protected ResourceKey<Level> dimension;
    protected UUID source;

    public BaseScanTask(ResourceKey<Level> dimension, UUID source) {
        this.dimension = dimension;
        this.source = source;
    }

    protected void sendMessage(Component component) {
        ServerManager.INSTANCE.listen(component);
    }

    protected void sendForceMessage(Component component) {
        this.sendMessage(component);
        if (!ServerManager.INSTANCE.isListening(this.source)) {
            ProcessListener.create(this.source).sendMessage(component);
        }
    }

    protected boolean isRegionFile(Path path) {
        return path.getFileName().toString().endsWith(".mca");
    }

    protected List<Path> getRegionFiles() {
        try {
            return ObjectIterators.pour(Files.newDirectoryStream(DimensionType.m_196975_(this.dimension, (Path)this.getSaveFile()).resolve("region"), this::isRegionFile).iterator());
        }
        catch (IOException e) {
            return ObjectLists.emptyList();
        }
    }

    protected Path getSaveFile() {
        return ServerLifecycleHooks.getCurrentServer().m_129843_(LevelResource.f_78182_).getParent();
    }

    protected ChunkPos getRegionPosition(Path regionFile) {
        try {
            String[] name = regionFile.getFileName().toString().split("\\.");
            return new ChunkPos(Integer.parseInt(name[1]), Integer.parseInt(name[2]));
        }
        catch (Exception e) {
            return null;
        }
    }
}

