/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.deleter;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.BitSet;
import java.util.Optional;
import java.util.function.LongPredicate;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.dimension.DimensionType;
import pregenerator.base.mixins.common.storage.RegionSectionCacheMixin;
import pregenerator.common.base.IInteruptable;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.collections.Long2ObjectConcurrentOpenHashMap;

public class ChunkDeleter
implements IInteruptable {
    private ResourceKey<Level> type;
    private Path worldFile;
    private ServerLevel world;
    private Long2ObjectLinkedOpenHashMap<RegionFile> chunkCache;
    private Long2ObjectLinkedOpenHashMap<RegionFile> poiCache;
    private ServerChunkCache provider;
    private LongPredicate predicate = T -> ChunkProcess.getHolder(this.provider, ChunkPos.m_45589_((int)SectionPos.m_123213_((long)T), (int)SectionPos.m_123230_((long)T))) == null;
    private Long2ObjectMap<Optional<PoiSection>> pointsOfInterest;
    private long totalChunks = 0L;
    private boolean disableMemoryLeak;
    private ObjectArrayList<DeleterEntry> entries = ObjectArrayList.wrap((Object[])new DeleterEntry[0]);

    public ChunkDeleter(ResourceKey<Level> type, Path worldFile, ServerLevel world) {
        this.type = type;
        this.worldFile = DimensionType.m_196975_(type, (Path)worldFile);
        this.world = world;
        if (this.world != null) {
            this.provider = world.m_7726_();
            this.chunkCache = this.getCache(this.provider);
            this.poiCache = this.getCache(this.provider.m_8484_());
            Long2ObjectMap map = ((RegionSectionCacheMixin)this.provider.m_8484_()).getStorage();
            if (map instanceof Long2ObjectConcurrentOpenHashMap) {
                this.pointsOfInterest = map;
            } else {
                this.pointsOfInterest = new Long2ObjectConcurrentOpenHashMap(map);
                ((RegionSectionCacheMixin)this.provider.m_8484_()).setStorage(this.pointsOfInterest);
            }
        }
    }

    public ChunkDeleter init(Long2ObjectMap<BitSet> maps, ChunkPos center, IProcess.PrepareProgress progress) {
        if (!progress.isAlive()) {
            return this;
        }
        progress.growMax(maps.size());
        this.entries.ensureCapacity(maps.size());
        for (Long2ObjectMap.Entry entry : Long2ObjectMaps.fastIterable(maps)) {
            progress.growValue(1);
            DeleterEntry delete = new DeleterEntry(this, new ChunkPos(ChunkPos.m_45592_((long)entry.getLongKey()) << 5, ChunkPos.m_45602_((long)entry.getLongKey()) << 5), (BitSet)entry.getValue());
            if (!delete.canDelete()) continue;
            this.entries.add((Object)delete);
            this.totalChunks += (long)((BitSet)entry.getValue()).cardinality();
        }
        ObjectArrays.parallelQuickSort((Object[])((DeleterEntry[])this.entries.elements()), (int)0, (int)this.entries.size(), (o1, o2) -> Long.compare(o2.getDistanceToCenter(center), o1.getDistanceToCenter(center)));
        return this;
    }

    public void start() {
        if (this.world == null) {
            return;
        }
        this.provider.m_8419_(true);
        LongLinkedOpenHashSet toRemove = new LongLinkedOpenHashSet();
        this.pointsOfInterest.keySet().forEach(arg_0 -> this.lambda$start$2((LongSet)toRemove, arg_0));
        this.pointsOfInterest.keySet().removeAll((LongCollection)toRemove);
        ObjectArrayList list = new ObjectArrayList(this.chunkCache.values());
        this.chunkCache.clear();
        for (RegionFile file : list) {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
        list = new ObjectArrayList(this.poiCache.values());
        this.poiCache.clear();
        for (RegionFile file : list) {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
    }

    public void onFinished() {
        if (this.disableMemoryLeak) {
            return;
        }
        if (this.pointsOfInterest instanceof Long2ObjectConcurrentOpenHashMap) {
            ((RegionSectionCacheMixin)this.provider.m_8484_()).setStorage(((Long2ObjectConcurrentOpenHashMap)this.pointsOfInterest).getSyncer());
        }
    }

    public ResourceKey<Level> getType() {
        return this.type;
    }

    public DeleterEntry getNextTask() {
        return this.entries.isEmpty() ? null : (DeleterEntry)this.entries.pop();
    }

    public boolean isDone() {
        return this.entries.isEmpty();
    }

    public long getTotal() {
        return this.totalChunks;
    }

    @Override
    public void interrupt() {
        this.entries.clear();
        this.onFinished();
    }

    protected boolean canDelete(int x, int z) {
        return this.provider == null || !this.provider.m_5563_(x, z);
    }

    private /* synthetic */ void lambda$start$2(LongSet toRemove, long T) {
        if (this.predicate.test(T)) {
            toRemove.add(T);
        }
    }

    static class DeleterEntry {
        ChunkDeleter owner;
        ChunkPos position;
        BitSet toDelete;
        int size;
        int skipped;
        int removed;

        public DeleterEntry(ChunkDeleter owner, ChunkPos position, BitSet toDelete) {
            this.owner = owner;
            this.position = position;
            this.toDelete = toDelete;
            this.size = toDelete.cardinality();
        }

        public boolean canDelete() {
            return Files.exists(this.owner.worldFile.resolve("region/r." + (this.position.f_45578_ >> 5) + "." + (this.position.f_45579_ >> 5) + ".mca"), new LinkOption[0]);
        }

        long getDistanceToCenter(ChunkPos center) {
            long x = this.position.f_45578_ - center.f_45578_;
            long z = this.position.f_45579_ - center.f_45579_;
            return x * x + z * z;
        }

        public int size() {
            return this.size;
        }

        public int getRemoved() {
            return this.removed;
        }

        public int getSkipped() {
            return this.skipped;
        }

        public void update() {
            String pos = "r." + (this.position.f_45578_ >> 5) + "." + (this.position.f_45579_ >> 5) + ".mca";
            int[] output = this.delete(pos, this.owner.worldFile.resolve("region"));
            this.delete(pos, this.owner.worldFile.resolve("poi"));
            this.delete(pos, this.owner.worldFile.resolve("entities"));
            this.removed = output[0];
            this.skipped = output[1];
        }

        public int[] delete(String file, Path folder) {
            if (Files.notExists(folder, new LinkOption[0]) || Files.notExists(folder.resolve(file), new LinkOption[0])) {
                return new int[]{this.size, 0};
            }
            if (this.size == 1024) {
                try {
                    Files.deleteIfExists(folder.resolve(file));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return new int[]{this.size, 0};
            }
            try {
                Path mainFile = folder.resolve(file);
                Path tempFile = folder.resolve("temp.mca");
                Files.move(mainFile, tempFile, StandardCopyOption.REPLACE_EXISTING);
                RegionFile oldRegion = new RegionFile(tempFile, folder, false);
                RegionFile newRegion = new RegionFile(mainFile, folder, false);
                int stored = 0;
                int failed = 0;
                for (int i = 0; i < 1024; ++i) {
                    ChunkPos entry = new ChunkPos(i % 32, i / 32);
                    if (this.toDelete.get(i) && this.owner.canDelete(this.position.f_45578_ + entry.f_45578_, this.position.f_45579_ + entry.f_45579_) || !oldRegion.m_63682_(entry)) continue;
                    try {
                        DataInputStream read = oldRegion.m_63645_(entry);
                        if (read != null) {
                            DataOutputStream out = newRegion.m_63678_(entry);
                            this.copy(read, out);
                            out.close();
                        }
                        ++stored;
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ++failed;
                    }
                }
                Files.deleteIfExists(tempFile);
                if (stored == 0) {
                    Files.deleteIfExists(mainFile);
                }
                return new int[]{stored, failed};
            }
            catch (Exception e) {
                e.printStackTrace();
                return new int[]{0, this.size};
            }
        }

        public long copy(InputStream input, OutputStream output) throws IOException {
            byte[] buffer = new byte[8192];
            int n = 0;
            long count = 0L;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
            return count;
        }
    }
}

