/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.gui.api.IModConfig;
import carbonconfiglib.gui.api.IModConfigs;
import carbonconfiglib.gui.screen.ConfigSelectorScreen;
import carbonconfiglib.impl.internal.ModConfigs;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import pregenerator.PregenConfig;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.CycleButton;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.base.impl.comp.PregenButtonGroup;
import pregenerator.base.impl.comp.PregenCheckBox;
import pregenerator.base.impl.comp.PregenSlider;
import pregenerator.client.gui.PatreonImage;
import pregenerator.client.gui.RetrogenScreen;
import pregenerator.client.gui.commands.DeleteCommandScreen;
import pregenerator.client.gui.commands.GenCommandScreen;
import pregenerator.client.gui.commands.TaskScreen;
import pregenerator.common.networking.packets.CommandPacket;
import pregenerator.common.utils.config.internal.PregenOverlay;
import pregenerator.common.utils.misc.PregenAction;

public class PregenMenu
extends BasePregenScreen {
    public static Supplier<Screen> MENU = PregenMenu::new;
    protected PregenButtonGroup group = new PregenButtonGroup(this::setMenu);
    protected Menu[] menus = new Menu[]{new Menu(), new Menu(), new Menu()};
    PregenCheckBox.CheckboxState pregenOverlay = new PregenCheckBox.CheckboxState(false, true).withStateListener(this::togglePregen);
    PregenSlider.SliderState pregenPollRate = new PregenSlider.SliderState(1, 1, 20, this::ticks).setListener(this::setPregenPollRate);
    CycleButton.CycleState<Integer> listenState = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::autoListenState, 0, 1, 2);
    CycleButton.CycleState<Boolean> listening = new CycleButton.CycleState<Boolean>(Boolean.valueOf(false), this::listening, false, true);
    protected EnumMap<PregenAction, List<AbstractWidget>> permissions = new EnumMap(PregenAction.class);
    protected EnumSet<PregenAction> allowedActions = EnumSet.noneOf(PregenAction.class);
    boolean update = true;
    private int totalTasks = 0;
    private int runningTasks = 0;
    private int pausedTasks = 0;

    public PregenMenu() {
        super((Component)TextUtil.guiConstructor());
        this.sendToServer(new CommandPacket.Request());
    }

    protected void loadSettings() {
        PregenOverlay overlay = PregenConfig.INSTANCE.pregenOverlay;
        this.pregenOverlay.setChecked(overlay.isEnabled());
        this.pregenPollRate.set(overlay.getPollDelay());
    }

    @Override
    protected void m_7856_() {
        this.sendToServer(new CommandPacket.RequestPerms());
        this.update = true;
        this.loadSettings();
        super.m_7856_();
        this.group.clear();
        this.addInfoMenu(null, null);
        this.addServerDataMenu();
        this.addCommandMenu();
        this.button(-40, -30, 80, 18, Align.CENTER, Align.END, (Component)TextUtil.translate("gui.chunk_pregen.retrogen_selector.back"), T -> this.m_7379_());
        if (this.shoulShowPatreon()) {
            this.button(45, -30, 18, 18, Align.CENTER, Align.END, (Component)TextUtil.empty(), this::openPatreon).setTooltip((Component)TextUtil.translate("gui.chunk_pregen.button.patreon"));
        }
        this.setMenu(this.group.getActiveIndex());
    }

    protected void addInfoMenu(Consumer<List<AbstractWidget>> callback, Consumer<List<AbstractWidget>> postCallback) {
        this.group.addButton(this.button(15, 15, 40, 16, Align.START, Align.START, (Component)TextUtil.translate("gui.chunk_pregen.menu.info"), this.emptyClick()));
        this.menus[0].clear();
        List<AbstractWidget> list = this.menus[0].addMenu(this.button(this.getX(0), 35, 90, 16, Align.START, Align.START, (Component)TextUtil.translate("gui.chunk_pregen.menu.pregen_overlay"), this.emptyClick()));
        list.add((AbstractWidget)this.checkbox(180, 72, 14, 14, this.pregenOverlay));
        list.add((AbstractWidget)this.slider(134, 88, 60, 14, this.pregenPollRate));
        list.add((AbstractWidget)this.button(134, 104, 60, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.open"), this::openPregenConfig));
        if (callback == null) {
            this.menus[0].addEmptyMenu();
        } else {
            callback.accept(list);
        }
        list = this.menus[0].addMenu(this.button(this.getX(1), 35, 40, 16, Align.START, Align.START, (Component)TextUtil.translate("gui.chunk_pregen.menu.misc"), this.emptyClick()));
        list.add((AbstractWidget)this.cycleButton(134, 72, 60, 14, this.listenState, this::setChatListenState));
        list.add((AbstractWidget)this.cycleButton(134, 88, 60, 14, this.listening, this::setListening));
        list.add((AbstractWidget)this.button(134, 104, 60, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.open"), this::openConfig));
        if (postCallback != null) {
            postCallback.accept(list);
        }
    }

    protected void addServerDataMenu() {
        this.group.addEmptyButton();
    }

    protected void addCommandMenu() {
        this.group.addButton(this.button(this.getX(2), 15, 60, 16, Align.START, Align.START, (Component)TextUtil.translate("gui.chunk_pregen.menu.commands"), this.emptyClick()));
        this.menus[2].clear();
        List<AbstractWidget> list = this.menus[2].addMenu(this.button(15, 35, 95, 16, Align.START, Align.START, (Component)TextUtil.translate("gui.chunk_pregen.menu.task_generators"), this.emptyClick()));
        list.add((AbstractWidget)this.permission(PregenAction.COMMANDS, this.button(129, 72, 60, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.create"), this::openGenerationCreator)));
        list.add((AbstractWidget)this.permission(PregenAction.COMMANDS, this.button(129, 88, 60, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.create"), this::openDeletionCreator)));
        list = this.menus[2].addMenu(this.button(115, 35, 60, 16, Align.START, Align.START, (Component)TextUtil.translate("gui.chunk_pregen.menu.selectors"), this.emptyClick()));
        list.add((AbstractWidget)this.permission(PregenAction.COMMANDS, this.button(129, 72, 70, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.view_tasks"), this::openTaskList)));
        list.add((AbstractWidget)this.button(129, 88, 70, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.select"), this::openRetrogen));
        list = this.menus[2].addMenu(this.button(180, 35, 50, 16, Align.START, Align.START, (Component)TextUtil.translate("gui.chunk_pregen.menu.actions"), this.emptyClick()));
        list.add((AbstractWidget)this.permission(PregenAction.COMMANDS, this.button(129, 72, 90, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.pause"), this::pauseAll)));
        list.add((AbstractWidget)this.permission(PregenAction.COMMANDS, this.button(129, 88, 90, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.resume"), this::resumeAll)));
        list.add((AbstractWidget)this.permission(PregenAction.COMMANDS, this.button(129, 104, 90, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.stop"), this::stopAll)));
        list.add((AbstractWidget)this.permission(PregenAction.COMMANDS, this.button(129, 120, 90, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.continue"), this::continueAny)));
        list.add((AbstractWidget)this.permission(PregenAction.COMMANDS, this.button(129, 136, 90, 14, (Component)TextUtil.translate("gui.chunk_pregen.menu.remove"), this::removeAll)));
    }

    protected int getX(int index) {
        switch (index) {
            case 0: {
                return 15;
            }
            case 1: {
                return 110;
            }
            case 2: {
                return 60;
            }
        }
        return -1;
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.tick % 20 == 0) {
            this.sendToServer(new CommandPacket.Request());
        }
    }

    protected <T extends PregenButton> T permission(PregenAction action, T widget) {
        this.permissions.computeIfAbsent(action, T -> new ObjectArrayList()).add(widget);
        widget.setTooltip(this::permission);
        return (T)widget;
    }

    public void receiveData(int listeningState, boolean listening, int totalTasks, int runningTasks, int pausedTasks) {
        this.listenState.setValue(listeningState);
        this.listening.setValue(listening);
        this.totalTasks = totalTasks;
        this.runningTasks = runningTasks;
        this.pausedTasks = pausedTasks;
        if (this.update) {
            this.update = false;
            this.listening.updateText();
            this.listenState.updateText();
        }
    }

    public void receivePermissions(List<PregenAction> actions) {
        this.allowedActions.clear();
        this.allowedActions.addAll(actions);
    }

    private void updatePermissions() {
        for (Map.Entry<PregenAction, List<AbstractWidget>> entry : this.permissions.entrySet()) {
            boolean result = this.allowedActions.contains((Object)entry.getKey());
            for (AbstractWidget widget : entry.getValue()) {
                widget.f_93623_ = result;
            }
        }
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.updatePermissions();
        this.m_280273_(graphics);
        int index = this.group.getActiveIndex();
        this.renderMenuBackground(graphics, index, index < 0 || index >= this.menus.length ? -1 : this.menus[index].getIndex());
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int index;
        this.renderMenu(graphics, index, (index = this.group.getActiveIndex()) < 0 || index >= this.menus.length ? -1 : this.menus[index].getIndex());
    }

    protected void renderMenuBackground(GuiGraphics graphics, int index, int subIndex) {
        if (index == 0) {
            this.drawColorRegion(graphics, 15.0f, 55.0f, 200.0f, 122.0f, -905311734);
        } else {
            this.drawColorRegion(graphics, 15.0f, 55.0f, subIndex == 1 ? 205.0f : (float)(subIndex == 2 ? 225 : 195), subIndex == 2 ? 155.0f : 108.0f, -905311734);
        }
    }

    protected void renderMenu(GuiGraphics graphics, int index, int subIndex) {
        if (index == 0) {
            if (subIndex == 0) {
                this.drawUnalignedText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.pregen_overlay"), 18.0f, 58.0f, Align.START, -1);
                this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.enabled"), 18.0f, 72.0f, 160.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.poll_delay"), 18.0f, 88.0f, 114.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.more_settings"), 18.0f, 104.0f, 114.0f, 12.0f, Align.START, -1, 52323);
            } else {
                this.drawUnalignedText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.misc_entry"), 18.0f, 58.0f, Align.START, -1);
                this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.chat_state"), 18.0f, 72.0f, 114.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.listening"), 18.0f, 88.0f, 114.0f, 12.0f, Align.START, -1, 52323);
                this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.base_config"), 18.0f, 104.0f, 94.0f, 12.0f, Align.START, -1, 52323);
            }
        } else if (subIndex == 0) {
            this.drawUnalignedText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.task_generators"), 18.0f, 58.0f, Align.START, -1);
            this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.generation_tasks"), 18.0f, 72.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.deletion_tasks"), 18.0f, 88.0f, 109.0f, 12.0f, Align.START, -1, 52323);
        } else if (subIndex == 1) {
            this.drawUnalignedText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.selectors"), 18.0f, 58.0f, Align.START, -1);
            this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.task_list"), 18.0f, 72.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.retrogen_selector"), 18.0f, 88.0f, 109.0f, 12.0f, Align.START, -1, 52323);
        } else {
            this.drawUnalignedText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.actions"), 18.0f, 58.0f, Align.START, -1);
            this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.running_tasks", this.runningTasks - this.pausedTasks), 18.0f, 72.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.paused_tasks", this.pausedTasks), 18.0f, 88.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.active_tasks", this.runningTasks), 18.0f, 104.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.queued tasks", this.totalTasks - this.runningTasks), 18.0f, 120.0f, 109.0f, 12.0f, Align.START, -1, 52323);
            this.drawUnalignedScrollText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.menu.stored_tasks", this.totalTasks), 18.0f, 136.0f, 109.0f, 12.0f, Align.START, -1, 52323);
        }
        if (this.shoulShowPatreon()) {
            RenderSystem.setShaderTexture((int)0, (int)PatreonImage.PATREON_PIC.m_117963_());
            this.renderTexture(graphics, (float)this.centerX + 47.5f, this.f_96544_ - 28, 13.0f, 13.0f);
        }
    }

    public void m_7379_() {
        this.setScreen(null);
    }

    protected boolean shoulShowPatreon() {
        return true;
    }

    private void openPatreon(Button button) {
        String s = "https://www.patreon.com/Speiger";
        this.setScreen((Screen)new ConfirmLinkScreen(open -> {
            if (open) {
                Util.m_137581_().m_137646_(s);
            }
            this.setScreen(this);
        }, s, true));
    }

    private void togglePregen(boolean value) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.pregenOverlay.setEnabled(value);
        config.save();
    }

    private void setPregenPollRate(PregenSlider slider) {
        PregenConfig config = PregenConfig.INSTANCE;
        config.pregenOverlay.setPollRate(slider.get());
        config.save();
    }

    private void openPregenConfig(Button button) {
        CarbonConfig.openLocalConfigFolder((IModConfig)IModConfig.carbon((String)"chunkpregen", (ConfigHandler)PregenConfig.INSTANCE.getHandler()), (String[])new String[]{"client", "pregen-overlay"});
    }

    private void setListening(CycleButton<Boolean> state) {
        this.sendToServer(new CommandPacket.Action(8 + (state.getValue() != false ? 0 : 1)));
    }

    private void setChatListenState(CycleButton<Integer> state) {
        this.sendToServer(new CommandPacket.Action(state.getValue() + 5));
    }

    private void openConfig(Button button) {
        ModConfigs config = new ModConfigs((ModContainer)ModList.get().getModContainerById("chunkpregen").orElse(null));
        config.addConfig(PregenConfig.INSTANCE.getHandler());
        this.setScreen((Screen)new ConfigSelectorScreen((IModConfigs)config, (Screen)this));
    }

    protected void openGenerationCreator(Button button) {
        this.setScreen(new GenCommandScreen(this));
    }

    private void openDeletionCreator(Button button) {
        this.setScreen(new DeleteCommandScreen(this));
    }

    private void openTaskList(Button button) {
        this.setScreen(new TaskScreen(this));
    }

    private void openRetrogen(Button button) {
        this.setScreen(new RetrogenScreen(this));
    }

    private void pauseAll(Button button) {
        this.sendToServer(new CommandPacket.Action(0));
    }

    private void resumeAll(Button button) {
        this.sendToServer(new CommandPacket.Action(1));
    }

    private void stopAll(Button button) {
        this.sendToServer(new CommandPacket.Action(2));
    }

    private void continueAny(Button button) {
        this.sendToServer(new CommandPacket.Action(3));
    }

    private void removeAll(Button button) {
        this.sendToServer(new CommandPacket.Action(4));
    }

    public void setMenu(int index) {
        for (int i = 0; i < this.menus.length; ++i) {
            if (i == index) {
                this.menus[i].enable();
                continue;
            }
            this.menus[i].disable();
        }
    }

    private Component permission(PregenButton button) {
        return button.f_93623_ ? null : TextUtil.translate("gui.chunk_pregen.menu.tooltip.permission");
    }

    protected Component ticks(int value) {
        return TextUtil.translate(value > 1 ? "gui.chunk_pregen.menu.ticks" : "gui.chunk_pregen.menu.tick", value);
    }

    private Component listening(boolean value) {
        return TextUtil.translate(value ? "gui.chunk_pregen.menu.yes" : "gui.chunk_pregen.menu.no");
    }

    private Component autoListenState(int index) {
        return TextUtil.translate(index == 0 ? "gui.chunk_pregen.menu.listen_state.active" : (index == 2 ? "gui.chunk_pregen.menu.listen_state.passive" : "gui.chunk_pregen.menu.listen_state.ignoring"));
    }

    public static class Menu {
        PregenButtonGroup subMenus = new PregenButtonGroup(this::setMenu);
        List<AbstractWidget> menuItems = new ObjectArrayList();
        List<List<AbstractWidget>> widgets = new ObjectArrayList();

        private void addEmptyMenu() {
            this.subMenus.addEmptyButton();
            this.widgets.add((List<AbstractWidget>)new ObjectArrayList());
        }

        public List<AbstractWidget> addMenu(PregenButton activator) {
            this.subMenus.addButton(activator);
            this.menuItems.add((AbstractWidget)activator);
            ObjectArrayList result = new ObjectArrayList();
            this.widgets.add((List<AbstractWidget>)result);
            return result;
        }

        public void clear() {
            this.subMenus.clear();
            this.widgets.clear();
        }

        public void disable() {
            this.setMenu(-1);
            for (AbstractWidget entry : this.menuItems) {
                entry.f_93624_ = false;
            }
        }

        public void enable() {
            this.setMenu(this.subMenus.getActiveIndex());
            for (AbstractWidget entry : this.menuItems) {
                entry.f_93624_ = true;
            }
        }

        private void setMenu(int index) {
            int m = this.widgets.size();
            for (int i = 0; i < m; ++i) {
                boolean visible = index == i;
                for (AbstractWidget widget : this.widgets.get(i)) {
                    widget.f_93624_ = visible;
                }
            }
        }

        public int getIndex() {
            return this.subMenus.getActiveIndex();
        }
    }
}

