/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.base.impl.comp;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import pregenerator.base.api.TextUtil;

public class PregenText
extends EditBox {
    TextState state;

    public PregenText(Font font, int x, int y, int width, int height) {
        this(font, x, y, width, height, new TextState());
    }

    public PregenText(Font font, int x, int y, int width, int height, TextState state) {
        super(font, x, y, width, height, (Component)TextUtil.empty());
        this.state = state;
        this.m_94144_(state.getValue());
        this.m_94167_(state.getValue().isEmpty() ? state.getSuggestion() : "");
        this.m_94153_(state.getFilter());
        state.setOwner(this);
    }

    public static class TextState {
        Predicate<String> filter = Objects::nonNull;
        Consumer<String> callback;
        String value = "";
        String suggestion;
        PregenText owner;

        public TextState() {
        }

        public TextState(String value) {
            this.value = value;
        }

        public TextState(String value, Predicate<String> filter) {
            this.filter = filter;
            this.value = value;
        }

        public TextState(String value, String suggestion) {
            this.value = value;
            this.suggestion = suggestion;
        }

        public TextState(String value, Predicate<String> filter, String suggestion) {
            this.filter = filter;
            this.value = value;
            this.suggestion = suggestion;
        }

        void setOwner(PregenText owner) {
            if (this.owner != null) {
                this.owner.m_94151_(null);
            }
            this.owner = owner;
            if (owner == null) {
                return;
            }
            owner.m_94151_(this::updateValue);
        }

        public TextState setCallback(Consumer<String> listener) {
            this.callback = listener;
            return this;
        }

        public PregenText getOwner() {
            return this.owner;
        }

        public void setFilter(Predicate<String> filter, String defaultValue) {
            this.filter = filter;
            if (this.owner != null) {
                this.owner.m_94153_(filter);
            }
            if (filter != null && (!filter.test(this.value) || this.value.isEmpty())) {
                this.setValue(defaultValue);
            }
        }

        public Predicate<String> getFilter() {
            return this.filter;
        }

        void updateValue(String value) {
            this.value = value;
            if (this.callback != null) {
                this.callback.accept(value);
            }
            if (this.suggestion != null && this.owner != null) {
                this.owner.m_94167_(value.length() > 0 ? null : this.suggestion);
            }
        }

        public String getSuggestion() {
            return this.suggestion;
        }

        public TextState setSuggestion(String suggestion) {
            this.suggestion = suggestion;
            if (this.owner != null) {
                this.owner.m_94167_(suggestion);
            }
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public TextState setValue(String value) {
            if (value == null) {
                return this;
            }
            if (this.owner == null) {
                this.value = value;
            } else {
                this.owner.m_94144_(value);
            }
            return this;
        }
    }
}

