/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.metal.StructuralArmBlock;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StructuralArmBlockEntity
extends IEBaseBlockEntity
implements IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.ICollisionBounds,
IEBlockInterfaces.ISelectionBounds,
IEBlockInterfaces.IBlockBounds {
    private int totalLength = 1;
    private int slopePosition = 0;
    private Direction facing = null;
    private boolean onCeiling = false;
    private static final CachedShapesWithTransform<ShapeKey, Direction> SHAPES = CachedShapesWithTransform.createDirectional(key -> StructuralArmBlockEntity.getBounds(key.slopePos(), key.slopeLength(), key.onCeiling()));

    public StructuralArmBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.STRUCTURAL_ARM.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        int oldLength = this.totalLength;
        int oldPos = this.slopePosition;
        this.totalLength = nbt.m_128451_("totalLength");
        this.slopePosition = nbt.m_128451_("slopePosition");
        this.onCeiling = nbt.m_128471_("onCeiling");
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && (oldLength != this.totalLength || this.slopePosition != oldPos)) {
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
        this.facing = nbt.m_128425_("facing", 3) ? DirectionUtils.VALUES[nbt.m_128451_("facing")] : null;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128405_("totalLength", this.totalLength);
        nbt.m_128405_("slopePosition", this.slopePosition);
        if (this.facing != null) {
            nbt.m_128405_("facing", this.facing.ordinal());
        }
        nbt.m_128379_("onCeiling", this.onCeiling);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        boolean atEnd;
        boolean positive;
        super.onNeighborBlockChange(otherPos);
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (otherPos.equals((Object)this.f_58858_.m_5484_(this.getFacing(), 1))) {
            positive = true;
        } else if (otherPos.equals((Object)this.f_58858_.m_5484_(this.getFacing(), -1))) {
            positive = false;
        } else {
            return;
        }
        StructuralArmBlockEntity slope = null;
        BlockEntity atOther = this.f_58857_.m_7702_(otherPos);
        if (atOther instanceof StructuralArmBlockEntity) {
            StructuralArmBlockEntity tmp = (StructuralArmBlockEntity)atOther;
            BlockState stateHere = this.f_58857_.m_8055_(this.f_58858_);
            BlockState stateThere = this.f_58857_.m_8055_(otherPos);
            if (tmp.getFacing() == this.getFacing() && stateHere.m_60734_() == stateThere.m_60734_() && tmp.onCeiling == this.onCeiling) {
                slope = (StructuralArmBlockEntity)atOther;
            }
        }
        if ((atEnd = this.isAtEnd(positive)) == (slope == null)) {
            return;
        }
        if (slope == null) {
            int toEnd = this.blocksToEnd(positive);
            this.forEachSlopeBlockBeyond(positive, false, true, other -> {
                other.totalLength = toEnd - 1;
                if (positive) {
                    other.slopePosition -= this.slopePosition + 2;
                }
                this.updateNoNeighbours(other.f_58858_);
            });
            this.forEachSlopeBlockBeyond(!positive, true, true, other -> {
                other.totalLength = this.totalLength - toEnd;
                if (!positive) {
                    other.slopePosition -= this.slopePosition;
                }
                this.updateNoNeighbours(other.f_58858_);
            });
        } else {
            int oldLength = this.totalLength;
            if (!positive) {
                this.slopePosition += slope.totalLength;
            }
            this.totalLength += slope.totalLength;
            this.forEachSlopeBlockBeyond(positive, false, false, other -> {
                other.totalLength = this.totalLength;
                if (positive) {
                    other.slopePosition += oldLength;
                }
                this.updateNoNeighbours(other.f_58858_);
            });
            this.forEachSlopeBlockBeyond(!positive, false, false, other -> {
                other.totalLength = this.totalLength;
                if (!positive) {
                    other.slopePosition += this.totalLength - oldLength;
                }
                this.updateNoNeighbours(other.f_58858_);
            });
        }
        this.updateNoNeighbours(this.f_58858_);
    }

    private boolean isAtEnd(boolean positive) {
        if (positive) {
            return this.slopePosition == this.totalLength - 1;
        }
        return this.slopePosition == 0;
    }

    private int blocksToEnd(boolean positive) {
        if (positive) {
            return this.totalLength - this.slopePosition - 1;
        }
        return this.slopePosition;
    }

    private void forEachSlopeBlockBeyond(boolean positive, boolean includeThis, boolean removing, Consumer<StructuralArmBlockEntity> out) {
        if (positive) {
            for (int i = 1; i < this.totalLength - this.slopePosition; ++i) {
                this.acceptIfValid(i, removing, out);
            }
        } else {
            for (int i = -1; i >= -this.slopePosition; --i) {
                this.acceptIfValid(i, removing, out);
            }
        }
        if (includeThis) {
            out.accept(this);
        }
    }

    private void acceptIfValid(int offsetToHere, boolean removing, Consumer<StructuralArmBlockEntity> out) {
        BlockPos posI = this.f_58858_.m_5484_(this.getFacing(), offsetToHere);
        BlockEntity teAtI = this.f_58857_.m_7702_(posI);
        if (teAtI instanceof StructuralArmBlockEntity) {
            StructuralArmBlockEntity slope = (StructuralArmBlockEntity)teAtI;
            int offsetAtPos = this.slopePosition + offsetToHere;
            BlockState stateHere = this.f_58857_.m_8055_(this.f_58858_);
            BlockState stateThere = this.f_58857_.m_8055_(posI);
            if ((!removing || slope.totalLength == this.totalLength && slope.slopePosition == offsetAtPos) && slope.onCeiling == this.onCeiling && stateHere.m_60734_() == stateThere.m_60734_() && slope.getFacing() == this.getFacing()) {
                out.accept(slope);
            }
        }
    }

    private void updateNoNeighbours(BlockPos pos) {
        BlockState state = this.f_58857_.m_8055_(pos);
        this.f_58857_.m_7260_(pos, state, state, 3);
    }

    @Override
    public Direction getFacing() {
        if (this.facing != null) {
            return this.facing;
        }
        return IEBlockInterfaces.IStateBasedDirectional.super.getFacing();
    }

    @Override
    public void setFacing(Direction facing) {
        IEBlockInterfaces.IStateBasedDirectional.super.setFacing(facing);
        this.facing = null;
        this.totalLength = 1;
        this.slopePosition = 0;
        if (this.f_58857_ != null) {
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return StructuralArmBlock.FACING;
    }

    @Override
    public Direction getFacingForPlacement(BlockPlaceContext ctx) {
        Direction side = ctx.m_43719_();
        double relativeClickY = ctx.m_43720_().f_82480_ - (double)ctx.m_8083_().m_123342_();
        this.onCeiling = side == Direction.DOWN || side != Direction.UP && relativeClickY > 0.5;
        return IEBlockInterfaces.IStateBasedDirectional.super.getFacingForPlacement(ctx);
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(new ShapeKey(this.slopePosition, this.totalLength, this.onCeiling), this.getFacing());
    }

    private static List<AABB> getBounds(int slopePosition, int totalLength, boolean onCeiling) {
        double lowerH = ((double)slopePosition + 0.5) / (double)totalLength;
        double upperH = ((double)slopePosition + 1.0) / (double)totalLength;
        if (!onCeiling) {
            return ImmutableList.of((Object)new AABB(0.0, 0.0, 0.0, 1.0, lowerH, 1.0), (Object)new AABB(0.0, lowerH, 0.0, 1.0, upperH, 0.5));
        }
        return ImmutableList.of((Object)new AABB(0.0, 1.0 - lowerH, 0.0, 1.0, 1.0, 1.0), (Object)new AABB(0.0, 1.0 - upperH, 0.0, 1.0, 1.0 - lowerH, 0.5));
    }

    public int getSlopePosition() {
        return this.slopePosition;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public boolean isOnCeiling() {
        return this.onCeiling;
    }

    private record ShapeKey(int slopePos, int slopeLength, boolean onCeiling) {
    }
}

