/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.tile;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.client.IVertexBufferHolder;
import blusunrize.immersiveengineering.api.client.ieobj.IEOBJCallbacks;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelper;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import blusunrize.immersiveengineering.api.utils.client.ModelDataUtils;
import blusunrize.immersiveengineering.client.models.obj.callback.block.BucketWheelCallbacks;
import blusunrize.immersiveengineering.client.render.tile.BERenderUtils;
import blusunrize.immersiveengineering.client.render.tile.DynamicModel;
import blusunrize.immersiveengineering.client.render.tile.IEBlockEntityRenderer;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.BucketWheelLogic;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.NonNullSupplier;
import org.joml.Quaternionf;

public class BucketWheelRenderer
extends IEBlockEntityRenderer<MultiblockBlockEntityMaster<BucketWheelLogic.State>> {
    public static final String NAME = "bucket_wheel";
    public static DynamicModel WHEEL;
    private static final Cache<BucketWheelCallbacks.Key, IVertexBufferHolder> CACHED_BUFFERS;

    public void render(MultiblockBlockEntityMaster<BucketWheelLogic.State> tile, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        IMultiblockBEHelper helper = tile.getHelper();
        Direction facing = helper.getContext().getLevel().getOrientation().front();
        BucketWheelLogic.State state = (BucketWheelLogic.State)helper.getState();
        boolean mirrored = state.reverseRotation;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.5, 0.5);
        matrixStack.m_252781_(new Quaternionf().rotateY(1.5707964f));
        bufferIn = BERenderUtils.mirror(new MultiblockOrientation(facing, mirrored), matrixStack, bufferIn);
        float dir = facing == Direction.SOUTH ? 0.0f : (facing == Direction.NORTH ? (float)Math.PI : (facing == Direction.EAST ? 1.5707964f : -1.5707964f));
        matrixStack.m_252781_(new Quaternionf().rotateY(dir));
        float rot = state.rotation + (float)(state.active ? (Double)IEServerConfig.MACHINES.excavator_speed.get() * (double)partialTicks : 0.0);
        matrixStack.m_252781_(new Quaternionf().rotateX(rot * ((float)Math.PI / 180)));
        matrixStack.m_85837_(-0.5, -0.5, -0.5);
        try {
            BucketWheelCallbacks.Key key = BucketWheelCallbacks.INSTANCE.extractKey(null, null, null, tile);
            ModelData extraData = ModelDataUtils.single(IEOBJCallbacks.getModelProperty(BucketWheelCallbacks.INSTANCE), key);
            ((IVertexBufferHolder)CACHED_BUFFERS.get((Object)key, () -> IVertexBufferHolder.create((NonNullSupplier<List<BakedQuad>>)((NonNullSupplier)() -> WHEEL.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, extraData, RenderType.m_110451_()))))).render(RenderType.m_110451_(), combinedLightIn, combinedOverlayIn, bufferIn, matrixStack, state.reverseRotation);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        matrixStack.m_85849_();
    }

    public static void reset() {
        CACHED_BUFFERS.invalidateAll();
    }

    static {
        CACHED_BUFFERS = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(1L, TimeUnit.MINUTES).removalListener(rem -> ((IVertexBufferHolder)rem.getValue()).reset()).build();
    }
}

