/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool.assembler;

import blusunrize.immersiveengineering.api.tool.assembler.FluidStackRecipeQuery;
import blusunrize.immersiveengineering.api.tool.assembler.IngredientRecipeQuery;
import blusunrize.immersiveengineering.api.tool.assembler.ItemStackRecipeQuery;
import blusunrize.immersiveengineering.api.tool.assembler.RecipeQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class AssemblerHandler {
    private static final HashMap<Class<? extends Recipe>, IRecipeAdapter> registry = new LinkedHashMap<Class<? extends Recipe>, IRecipeAdapter>();
    private static final List<BiFunction<Ingredient, ItemStack, RecipeQuery>> specialIngredientConverters = new ArrayList<BiFunction<Ingredient, ItemStack, RecipeQuery>>();
    private static final List<BiFunction<ItemStack, ItemStack, RecipeQuery>> specialItemStackConverters = new ArrayList<BiFunction<ItemStack, ItemStack, RecipeQuery>>();
    public static IRecipeAdapter<Recipe<CraftingContainer>> defaultAdapter;

    public static void registerRecipeAdapter(Class<? extends Recipe> recipeClass, IRecipeAdapter adapter) {
        registry.put(recipeClass, adapter);
    }

    @Nonnull
    public static IRecipeAdapter<?> findAdapterForClass(Class<? extends Recipe> recipeClass) {
        IRecipeAdapter<Object> adapter = registry.get(recipeClass);
        boolean isSuperIRecipe = Recipe.class.isAssignableFrom(recipeClass.getSuperclass());
        adapter = adapter == null && recipeClass != Recipe.class && isSuperIRecipe ? AssemblerHandler.findAdapterForClass(recipeClass.getSuperclass()) : defaultAdapter;
        registry.put(recipeClass, adapter);
        return adapter;
    }

    @Nonnull
    public static <R extends Recipe<CraftingContainer>> IRecipeAdapter<R> findAdapter(R recipe) {
        return AssemblerHandler.findAdapterForClass(recipe.getClass());
    }

    public static void registerSpecialIngredientConverter(BiFunction<Ingredient, ItemStack, RecipeQuery> func) {
        specialIngredientConverters.add(func);
    }

    public static void registerSpecialItemStackConverter(BiFunction<ItemStack, ItemStack, RecipeQuery> func) {
        specialItemStackConverters.add(func);
    }

    private static <T> RecipeQuery fromFunctions(T in, ItemStack remaining, List<BiFunction<T, ItemStack, RecipeQuery>> converters) {
        for (BiFunction<T, ItemStack, RecipeQuery> func : converters) {
            RecipeQuery q = func.apply(in, remaining);
            if (q == null) continue;
            return q;
        }
        return null;
    }

    @Nullable
    public static RecipeQuery createQueryFromIngredient(Ingredient ingr, ItemStack remaining) {
        RecipeQuery special = AssemblerHandler.fromFunctions(ingr, remaining, specialIngredientConverters);
        if (special != null) {
            return special;
        }
        if (ingr.m_43947_()) {
            return null;
        }
        return new IngredientRecipeQuery(ingr, 1);
    }

    @Nullable
    public static RecipeQuery createQueryFromItemStack(ItemStack stack, ItemStack remaining) {
        if (stack.m_41619_()) {
            return null;
        }
        RecipeQuery special = AssemblerHandler.fromFunctions(stack, remaining, specialItemStackConverters);
        if (special != null) {
            return special;
        }
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        if (!fluidStack.isEmpty()) {
            return new FluidStackRecipeQuery(fluidStack);
        }
        return new ItemStackRecipeQuery(stack);
    }

    public static interface IRecipeAdapter<R extends Recipe<CraftingContainer>> {
        @Nullable
        public List<RecipeQuery> getQueriedInputs(R var1, NonNullList<ItemStack> var2, Level var3);
    }
}

