/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss.goal;

import com.aetherteam.aether.entity.monster.dungeon.boss.Slider;
import java.util.EnumSet;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class SliderMoveGoal
extends Goal {
    private final Slider slider;
    private Vec3 targetPoint;
    private float velocity;

    public SliderMoveGoal(Slider slider) {
        this.slider = slider;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.slider.isAwake() && !this.slider.m_21224_() && this.slider.getMoveDelay() <= 0) {
            this.targetPoint = this.slider.findTargetPoint();
            return this.targetPoint != null;
        }
        return false;
    }

    public boolean m_8045_() {
        if (!this.m_8036_()) {
            return false;
        }
        if (this.slider.getMoveDelay() > 0) {
            return false;
        }
        return !this.slider.f_19862_ && !this.slider.f_19863_;
    }

    public void m_8056_() {
        this.slider.setMoveDirection(null);
        this.slider.m_5496_(this.slider.getMoveSound(), 2.5f, 1.0f / (this.slider.m_217043_().m_188501_() * 0.2f + 0.9f));
    }

    public void m_8037_() {
        if (this.targetPoint == null) {
            this.m_8041_();
            return;
        }
        Direction moveDir = SliderMoveGoal.getMoveDirection(this.slider, this.targetPoint);
        if (SliderMoveGoal.axisDistance(this.targetPoint, this.slider.m_20182_(), moveDir) <= 0.0) {
            this.m_8041_();
            return;
        }
        if (this.velocity < this.slider.getMaxVelocity()) {
            this.velocity = Math.min(this.slider.getMaxVelocity(), this.velocity + this.slider.getVelocityIncrease());
        }
        this.slider.m_20256_(new Vec3((double)((float)moveDir.m_122429_() * this.velocity), (double)((float)moveDir.m_122430_() * this.velocity), (double)((float)moveDir.m_122431_() * this.velocity)));
    }

    public void m_8041_() {
        this.slider.setMoveDelay(this.slider.calculateMoveDelay());
        this.slider.setTargetPoint(null);
        this.targetPoint = null;
        this.velocity = 0.0f;
        this.slider.m_20256_(Vec3.f_82478_);
    }

    public boolean m_183429_() {
        return true;
    }

    private static Direction getMoveDirection(Slider slider, Vec3 targetPoint) {
        Direction moveDir = slider.getMoveDirection();
        if (moveDir == null) {
            double x = targetPoint.f_82479_ - slider.m_20185_();
            double y = targetPoint.f_82480_ - slider.m_20186_();
            double z = targetPoint.f_82481_ - slider.m_20189_();
            moveDir = Slider.calculateDirection(x, y, z);
            slider.setMoveDirection(moveDir);
        }
        return moveDir;
    }

    private static double axisDistance(Vec3 target, Vec3 start, Direction direction) {
        double x = target.m_7096_() - start.m_7096_();
        double y = target.m_7098_() - start.m_7098_();
        double z = target.m_7094_() - start.m_7094_();
        return x * (double)direction.m_122429_() + y * (double)direction.m_122430_() + z * (double)direction.m_122431_();
    }
}

