/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.particle;

import com.aetherteam.aether.entity.monster.AbstractWhirlwind;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public abstract class AbstractWhirlwindParticle<T extends AbstractWhirlwind>
extends TextureSheetParticle {
    private static final TargetingConditions TARGET_CONDITION = TargetingConditions.m_148353_();
    private final SpriteSet animatedSprite;
    @Nullable
    protected final AbstractWhirlwind whirlwind;

    public AbstractWhirlwindParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprite) {
        super(level, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed);
        this.animatedSprite = sprite;
        this.whirlwind = (AbstractWhirlwind)level.m_45963_(this.getWhirlwindType(), TARGET_CONDITION, null, xCoord, yCoord, zCoord, new AABB(this.f_107212_, this.f_107213_, this.f_107214_, this.f_107212_ + 1.0, this.f_107213_ + 1.0, this.f_107214_ + 1.0));
        if (this.whirlwind != null) {
            this.m_107264_(this.whirlwind.m_20185_(), this.whirlwind.m_20186_(), this.whirlwind.m_20189_());
            this.f_107215_ = xSpeed + (Math.random() * 2.0 - 1.0) * this.getBaseSpeedModifier();
            this.f_107216_ = ySpeed + (Math.random() * 2.0 - 1.0) * this.getBaseSpeedModifier();
            this.f_107217_ = zSpeed + (Math.random() * 2.0 - 1.0) * this.getBaseSpeedModifier();
        }
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
        this.m_108339_(this.animatedSprite);
        if (this.whirlwind != null && this.whirlwind.m_6084_()) {
            float x = (float)(this.whirlwind.m_20185_() - this.f_107212_);
            float y = (float)(this.whirlwind.m_20186_() - this.f_107213_);
            float z = (float)(this.whirlwind.m_20189_() - this.f_107214_);
            float d1 = Mth.m_14116_((float)(x * x + y * y + z * z));
            double minY = this.m_107277_().f_82289_ - this.f_107213_;
            double d2 = Math.atan2(this.whirlwind.m_20185_() - this.f_107212_, this.whirlwind.m_20189_() - this.f_107214_) / 0.0175;
            this.f_107215_ = -Math.cos(0.0175 * (d2 += 160.0)) * ((double)d1 * 2.5 - minY) * 0.1;
            this.f_107217_ = Math.sin(0.01745 * d2) * ((double)d1 * 2.5 - minY) * 0.1;
            this.f_107216_ = 0.115;
        }
        this.f_107216_ += 0.004;
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    protected abstract double getBaseSpeedModifier();

    public abstract Class<T> getWhirlwindType();
}

