/*
 * Decompiled with CFR 0.152.
 */
package fuzs.moblassos.world.item;

import fuzs.moblassos.MobLassos;
import fuzs.moblassos.capability.VillagerContractCapability;
import fuzs.moblassos.config.ServerConfig;
import fuzs.moblassos.init.ModRegistry;
import fuzs.moblassos.util.LassoMobHelper;
import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LassoItem
extends Item {
    public static final String TAG_STORED_ENTITY = "StoredEntity";
    public static final String TAG_ENTITY_PICK_UP_TIME = "EntityPickUpTime";
    public static final String TAG_ENTITY_RELEASE_TIME = "EntityReleaseTime";
    private static final int BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);
    private final Type type;

    public LassoItem(Item.Properties properties, Type type) {
        super(properties);
        this.type = type;
    }

    public static EventResultHolder<InteractionResult> onEntityInteract(Player player, Level level, InteractionHand hand, Entity entity) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof LassoItem) {
            LassoItem item2 = (LassoItem)item;
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                if (entity.m_6084_()) {
                    if (!(stack.m_41782_() && stack.m_41783_().m_128425_(TAG_ENTITY_RELEASE_TIME, 4) || item2.hasStoredEntity(stack) || !item2.type.canPlayerPickUp(player, mob) || player.m_9236_().f_46443_)) {
                        entity.m_216990_((SoundEvent)ModRegistry.LASSO_PICK_UP_SOUND_EVENT.get());
                        if (entity.m_8077_()) {
                            stack.m_41714_(entity.m_7770_());
                        }
                        CompoundTag tag = LassoMobHelper.saveEntity(entity);
                        entity.m_146870_();
                        stack.m_41700_(TAG_STORED_ENTITY, (Tag)tag);
                        if (item2.type.hasMaxHoldingTime()) {
                            stack.m_41783_().m_128356_(TAG_ENTITY_PICK_UP_TIME, level.m_46467_());
                        }
                    }
                    return EventResultHolder.interrupt((Object)InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_));
                }
            }
        }
        return EventResultHolder.pass();
    }

    public int getColor(ItemStack stack, int tintIndex) {
        if (tintIndex == 0) {
            return -1;
        }
        SpawnEggItem spawnEggItem = SpawnEggItem.m_43213_(this.getStoredEntityType(stack));
        if (spawnEggItem == null) {
            return -1;
        }
        return spawnEggItem.m_43211_(tintIndex - 1);
    }

    public boolean hasStoredEntity(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(TAG_STORED_ENTITY);
    }

    @Nullable
    public EntityType<?> getStoredEntityType(ItemStack stack) {
        if (!this.hasStoredEntity(stack)) {
            return null;
        }
        return EntityType.m_20637_((CompoundTag)stack.m_41737_(TAG_STORED_ENTITY)).orElse(null);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!this.hasStoredEntity(context.m_43722_())) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemStack = context.m_43722_();
        BlockPos clickedPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockState = level.m_8055_(clickedPos);
        BlockPos releasePos = blockState.m_60812_((BlockGetter)level, clickedPos).m_83281_() ? clickedPos : clickedPos.m_121945_(direction);
        this.releaseContents((Entity)context.m_43723_(), level, itemStack, clickedPos, releasePos);
        this.tryConvertPickUpTime(level, itemStack);
        return InteractionResult.CONSUME;
    }

    private void releaseContents(Entity entity, Level level, ItemStack itemStack, BlockPos clickedPos, BlockPos releasePos) {
        CompoundTag tag = itemStack.m_41737_(TAG_STORED_ENTITY);
        if (this.releaseContentAt(tag, level, releasePos, itemStack)) {
            level.m_142346_(entity, GameEvent.f_157810_, clickedPos);
        }
        itemStack.m_41749_(TAG_STORED_ENTITY);
        itemStack.m_41787_();
        this.tryClearTag(itemStack);
    }

    private void tryConvertPickUpTime(Level level, ItemStack itemStack) {
        if (itemStack.m_41782_() && itemStack.m_41783_().m_128425_(TAG_ENTITY_PICK_UP_TIME, 4)) {
            long pickUpTime = itemStack.m_41783_().m_128454_(TAG_ENTITY_PICK_UP_TIME);
            itemStack.m_41783_().m_128473_(TAG_ENTITY_PICK_UP_TIME);
            long currentHoldingTime = level.m_46467_() - pickUpTime;
            itemStack.m_41783_().m_128356_(TAG_ENTITY_RELEASE_TIME, level.m_46467_() + Math.min(0L, currentHoldingTime - (long)this.getMaxHoldingTime(itemStack)) / 5L);
            this.tryClearTag(itemStack);
        }
    }

    private boolean releaseContentAt(CompoundTag tag, Level level, BlockPos pos, ItemStack stack) {
        if (!level.f_46443_ && !tag.m_128456_()) {
            LassoMobHelper.removeTagKeys((ServerLevel)level, tag);
            return EntityType.m_20642_((CompoundTag)tag, (Level)level).map(entity -> {
                LassoMobHelper.moveEntityTo(entity, level, pos, true);
                entity.m_20256_(Vec3.f_82478_);
                level.m_7967_(entity);
                if (stack.m_41788_() && entity instanceof LivingEntity) {
                    entity.m_6593_(stack.m_41786_());
                }
                entity.m_216990_((SoundEvent)ModRegistry.LASSO_RELEASE_SOUND_EVENT.get());
                return entity;
            }).isPresent();
        }
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        int hostileDamageRate;
        if (this.type == Type.HOSTILE && this.hasStoredEntity(stack) && (hostileDamageRate = ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).hostileDamageRate) != -1 && level.m_46467_() % ((long)hostileDamageRate * 20L) == 0L) {
            entity.m_6469_(level.m_269111_().m_269425_(), 1.0f);
        }
        if (this.type.hasMaxHoldingTime() && stack.m_41782_()) {
            int maxHoldingTime;
            long currentHoldingTime;
            if (stack.m_41783_().m_128425_(TAG_ENTITY_PICK_UP_TIME, 4) && (currentHoldingTime = this.getCurrentHoldingTime(level, stack, TAG_ENTITY_PICK_UP_TIME, maxHoldingTime = this.getMaxHoldingTime(stack))) >= (long)maxHoldingTime) {
                this.releaseContents(entity, level, stack, entity.m_20183_(), entity.m_20183_());
                this.tryConvertPickUpTime(level, stack);
            }
            if (stack.m_41783_().m_128425_(TAG_ENTITY_RELEASE_TIME, 4) && (currentHoldingTime = this.getCurrentHoldingTime(level, stack, TAG_ENTITY_RELEASE_TIME, maxHoldingTime = this.getMaxHoldingTime(stack) / 5)) >= (long)maxHoldingTime) {
                stack.m_41783_().m_128473_(TAG_ENTITY_RELEASE_TIME);
                this.tryClearTag(stack);
            }
        }
    }

    private void tryClearTag(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128456_()) {
            stack.m_41751_(null);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return this.type.hasMaxHoldingTime() && stack.m_41782_() && (stack.m_41783_().m_128425_(TAG_ENTITY_PICK_UP_TIME, 4) || stack.m_41783_().m_128425_(TAG_ENTITY_RELEASE_TIME, 4));
    }

    public int m_142158_(ItemStack stack) {
        int maxHoldingTime = this.getMaxHoldingTime(stack);
        long currentHoldingTime = 0L;
        if (stack.m_41783_().m_128425_(TAG_ENTITY_PICK_UP_TIME, 4)) {
            currentHoldingTime = this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), stack, TAG_ENTITY_PICK_UP_TIME, maxHoldingTime);
        }
        if (stack.m_41783_().m_128425_(TAG_ENTITY_RELEASE_TIME, 4)) {
            currentHoldingTime = (long)(maxHoldingTime /= 5) - this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), stack, TAG_ENTITY_RELEASE_TIME, maxHoldingTime);
        }
        return Math.round(13.0f - (float)currentHoldingTime * 13.0f / (float)maxHoldingTime);
    }

    public int m_142159_(ItemStack stack) {
        return BAR_COLOR;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (this.hasStoredEntity(stack)) {
            MutableComponent component = Component.m_237110_((String)"gui.entity_tooltip.type", (Object[])new Object[]{this.getStoredEntityType(stack).m_20676_()});
            tooltipComponents.add((Component)component.m_130940_(ChatFormatting.BLUE));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)(this.m_5524_() + ".desc")).m_130940_(ChatFormatting.GRAY));
            if (ModRegistry.EMERALD_LASSO_ITEM.isPresent() && this == ModRegistry.EMERALD_LASSO_ITEM.get()) {
                tooltipComponents.add((Component)Component.m_237115_((String)(((Item)ModRegistry.CONTRACT_ITEM.get()).m_5524_() + ".desc")).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (isAdvanced.m_7050_() && stack.m_41782_() && MobLassos.CONFIG.getHolder(ServerConfig.class).isAvailable()) {
            boolean hasPickUpTime = stack.m_41783_().m_128425_(TAG_ENTITY_PICK_UP_TIME, 4);
            boolean hasReleaseTime = stack.m_41783_().m_128425_(TAG_ENTITY_RELEASE_TIME, 4);
            if (hasPickUpTime || hasReleaseTime) {
                int maxHoldingTime = this.getMaxHoldingTime(stack);
                long currentHoldingTime = 0L;
                if (hasPickUpTime) {
                    currentHoldingTime = this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), stack, TAG_ENTITY_PICK_UP_TIME, maxHoldingTime);
                }
                if (hasReleaseTime) {
                    currentHoldingTime = this.getCurrentHoldingTime(Proxy.INSTANCE.getClientLevel(), stack, TAG_ENTITY_RELEASE_TIME, maxHoldingTime /= 5);
                }
                tooltipComponents.add((Component)Component.m_237110_((String)"item.moblassos.lasso.remaining", (Object[])new Object[]{((long)maxHoldingTime - currentHoldingTime) / 20L}).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    private long getCurrentHoldingTime(Level level, ItemStack stack, String timeTagKey, int maxHoldingTime) {
        long time = stack.m_41783_().m_128454_(timeTagKey);
        long currentHoldingTime = level.m_46467_() - time;
        return Math.min(currentHoldingTime, (long)maxHoldingTime);
    }

    public int getMaxHoldingTime(ItemStack stack) {
        int time = this.type.getMaxHoldingTime();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)ModRegistry.HOLDING_ENCHANTMENT.get()), (ItemStack)stack);
        if (level > 0) {
            time = (int)((double)time + (double)(time * level) * ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).holdingMultiplier);
        }
        return time;
    }

    public void m_142023_(ItemEntity itemEntity) {
        ItemStack stack = itemEntity.m_32055_();
        if (this.hasStoredEntity(stack)) {
            CompoundTag storedEntity = stack.m_41737_(TAG_STORED_ENTITY);
            this.releaseContentAt(storedEntity, itemEntity.m_9236_(), itemEntity.m_20183_(), stack);
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_142095_() {
        return false;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }

    public static enum Type {
        GOLDEN(entity -> (entity instanceof Animal || entity instanceof AmbientCreature) && !(entity instanceof Enemy), () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).goldenLassoTime, () -> ModRegistry.GOLDEN_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        AQUA(entity -> entity instanceof WaterAnimal && !(entity instanceof Enemy), () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).aquaLassoTime, () -> ModRegistry.AQUA_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        DIAMOND(entity -> (entity instanceof Animal || entity instanceof AmbientCreature || entity instanceof WaterAnimal) && !(entity instanceof Enemy), () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).diamondLassoTime, () -> ModRegistry.DIAMOND_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        EMERALD(entity -> entity instanceof AbstractVillager && ModRegistry.VILLAGER_CONTRACT_CAPABILITY.maybeGet(entity).filter(VillagerContractCapability::hasAcceptedContract).isPresent(), () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).emeraldLassoTime, () -> ModRegistry.EMERALD_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        HOSTILE(entity -> entity instanceof Enemy, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).hostileLassoTime, () -> ModRegistry.HOSTILE_LASSO_BLACKLIST_ENTITY_TYPE_TAG),
        CREATIVE(entity -> true, () -> ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).creativeLassoTime, () -> ModRegistry.CREATIVE_LASSO_BLACKLIST_ENTITY_TYPE_TAG);

        private final Predicate<Mob> mobFilter;
        private final IntSupplier holdingTime;
        private final Supplier<TagKey<EntityType<?>>> blacklist;

        private Type(Predicate<Mob> mobFilter, IntSupplier holdingTime, Supplier<TagKey<EntityType<?>>> blacklist) {
            this.mobFilter = mobFilter;
            this.holdingTime = holdingTime;
            this.blacklist = blacklist;
        }

        public boolean hasMaxHoldingTime() {
            return this.holdingTime.getAsInt() != -1;
        }

        public int getMaxHoldingTime() {
            return this.holdingTime.getAsInt() * 20;
        }

        public boolean canPlayerPickUp(Player player, Mob mob) {
            if (CommonAbstractions.INSTANCE.isBossMob(mob.m_6095_())) {
                return false;
            }
            double hostileMobHealth = ((ServerConfig)MobLassos.CONFIG.get(ServerConfig.class)).hostileMobHealth;
            if (!mob.m_6095_().m_204039_(this.blacklist.get()) && this.mobFilter.test(mob)) {
                if (this == HOSTILE && (double)(mob.m_21223_() / mob.m_21233_()) >= hostileMobHealth) {
                    player.m_5661_((Component)Component.m_237110_((String)(((Item)ModRegistry.HOSTILE_LASSO_ITEM.get()).m_5524_() + ".hostile"), (Object[])new Object[]{mob.m_5446_(), String.format("%.0f", hostileMobHealth * (double)mob.m_21233_()), String.format("%.0f", Float.valueOf(mob.m_21223_()))}).m_130940_(ChatFormatting.RED), true);
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

