/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import java.util.List;
import me.paypur.tconjei.TConJEI;
import me.paypur.tconjei.Utils;
import me.paypur.tconjei.jei.ArmorStatsCategory;
import me.paypur.tconjei.jei.HarvestStatsCategory;
import me.paypur.tconjei.jei.MaterialStatsWrapper;
import me.paypur.tconjei.jei.RangedStatsCategory;
import me.paypur.tconjei.jei.SlimeskullStatsCategory;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tools.stats.SkullStats;

@JeiPlugin
public class TConJEIPlugin
implements IModPlugin {
    ResourceLocation UID = new ResourceLocation("tconjei", "jei_plugin");
    public static final RecipeType<MaterialStatsWrapper> HARVEST_STATS = RecipeType.create((String)"tconjei", (String)"harvest_stats", MaterialStatsWrapper.class);
    public static final RecipeType<MaterialStatsWrapper> RANGED_STATS = RecipeType.create((String)"tconjei", (String)"ranged_stats", MaterialStatsWrapper.class);
    public static final RecipeType<MaterialStatsWrapper> ARMOR_STATS = RecipeType.create((String)"tconjei", (String)"armor_stats", MaterialStatsWrapper.class);
    public static final RecipeType<MaterialStatsWrapper> SKULL_STATS = RecipeType.create((String)"tconjei", (String)"skull_stats", MaterialStatsWrapper.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return this.UID;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<MaterialStatsWrapper> statsWrappers = Utils.getMaterialWrappers();
        registration.addRecipes(HARVEST_STATS, statsWrappers.stream().filter(w -> w.hasStats(TConJEI.HARVEST_STAT_IDS)).toList());
        registration.addRecipes(RANGED_STATS, statsWrappers.stream().filter(w -> w.hasStats(TConJEI.RANGED_STAT_IDS)).toList());
        registration.addRecipes(ARMOR_STATS, statsWrappers.stream().filter(w -> w.hasStats(TConJEI.ARMOR_STAT_IDS)).toList());
        registration.addRecipes(SKULL_STATS, statsWrappers.stream().filter(w -> w.hasStats(List.of(SkullStats.ID))).toList());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new HarvestStatsCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new RangedStatsCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new ArmorStatsCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new SlimeskullStatsCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TinkerTables.tinkerStation.m_5456_()), new RecipeType[]{HARVEST_STATS, RANGED_STATS, ARMOR_STATS, SKULL_STATS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TinkerTables.tinkersAnvil.m_5456_()), new RecipeType[]{HARVEST_STATS, RANGED_STATS, ARMOR_STATS, SKULL_STATS});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)TinkerTables.scorchedAnvil.m_5456_()), new RecipeType[]{HARVEST_STATS, RANGED_STATS, ARMOR_STATS, SKULL_STATS});
    }
}

