/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import me.paypur.tconjei.ColorProvider;
import me.paypur.tconjei.Utils;
import me.paypur.tconjei.jei.MaterialStatsWrapper;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolPartsHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.utils.Util;

public abstract class AbstractMaterialStatsCategory
implements IRecipeCategory<MaterialStatsWrapper> {
    protected static final Font FONT = Minecraft.m_91087_().f_91062_;
    public static final int LINE_HEIGHT = 10;
    protected static final float LINE_SPACING = 0.5f;
    protected static final int WIDTH = 180;
    protected static final int HEIGHT = 200;
    protected RecipeType<MaterialStatsWrapper> recipeType;
    protected List<MaterialStatsId> statsIds;
    protected Component title;
    protected IDrawable background;
    protected IDrawable icon;
    @Nullable
    protected TagKey<Item> tag;

    public AbstractMaterialStatsCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(180, 200);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MaterialStatsWrapper wrapper, IFocusGroup focuses) {
        FluidStack fluidStack = wrapper.getFluidStack();
        if (!fluidStack.isEmpty()) {
            int bucket = 1000;
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 18, 0).addFluidStack(fluidStack.getFluid(), 1000L);
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addFluidStack(fluidStack.getFluid(), 1000L);
        }
        List<ItemStack> inputs = wrapper.getInputs();
        List<ItemStack> inputsParts = this.getInputsParts(wrapper.getMaterialId());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStacks(inputs);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 164, 0).addItemStacks(inputsParts);
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(inputs);
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(inputsParts);
    }

    public void draw(MaterialStatsWrapper wrapper, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        float lineNumber;
        int tier = wrapper.material().getTier();
        int color = MaterialTooltipCache.getColor((MaterialVariantId)wrapper.getMaterialId()).m_131265_();
        float f = lineNumber = 0.0f;
        lineNumber = f + 1.0f;
        this.drawComponentShadowCentered(gui, (Component)Component.m_237115_((String)Util.makeTranslationKey((String)"material", (ResourceLocation)wrapper.getMaterialId())).m_130940_(ChatFormatting.UNDERLINE), f, color);
        float f2 = lineNumber;
        lineNumber = f2 + 1.0f;
        this.drawComponentShadowCentered(gui, (Component)Component.m_237110_((String)"tconjei.tooltip.tier", (Object[])new Object[]{tier}), f2, ColorProvider.getTierColor(tier).orElse(color));
        List<IMaterialStats> statsList = this.statsIds.stream().map(wrapper::getStats).filter(Optional::isPresent).map(Optional::get).toList();
        Optional statOptional = statsList.stream().findFirst();
        if (statOptional.isPresent()) {
            this.drawTraits(gui, wrapper.getTraits(((IMaterialStats)statOptional.get()).getIdentifier()), lineNumber);
        }
        for (IMaterialStats stats : statsList) {
            float f3 = lineNumber;
            lineNumber = f3 + 1.0f;
            this.drawComponent(gui, (Component)stats.getLocalizedName().m_130940_(ChatFormatting.UNDERLINE), 0, f3, color, true);
            for (Component line : stats.getLocalizedInfo()) {
                float f4 = lineNumber;
                lineNumber = f4 + 1.0f;
                this.drawStatComponent(gui, line, f4);
            }
            lineNumber += 0.5f;
        }
    }

    public void getTooltip(ITooltipBuilder tooltips, MaterialStatsWrapper wrapper, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (this.addMaterialTooltip(tooltips, wrapper, mouseX, mouseY)) {
            return;
        }
        float lineNumber = 2.0f;
        for (MaterialStatsId statsId : this.statsIds) {
            Optional statsOptional = wrapper.getStats(statsId);
            if (statsOptional.isEmpty()) continue;
            IMaterialStats stats = (IMaterialStats)statsOptional.get();
            float f = lineNumber;
            lineNumber = f + 1.0f;
            if (this.addTraitTooltip(tooltips, wrapper.getTraits(stats.getIdentifier()), mouseX, mouseY, f)) {
                return;
            }
            for (int i = 0; i < stats.getLocalizedDescriptions().size(); ++i) {
                float f2 = lineNumber;
                lineNumber = f2 + 1.0f;
                if (!this.addStatTooltip(tooltips, stats, i, mouseX, mouseY, f2)) continue;
                return;
            }
            lineNumber += 0.5f;
        }
    }

    protected List<ItemStack> getInputsParts(MaterialId materialId) {
        if (this.tag == null) {
            return List.of();
        }
        HashSet seen = new HashSet();
        return RegistryHelper.getTagValueStream(this.tag).filter(item -> item instanceof IModifiable).map(item -> ((IModifiable)item).getToolDefinition()).map(ToolPartsHook::parts).flatMap(item -> item.stream().filter(part -> part.canUseMaterial(materialId)).map(part -> part.withMaterial((MaterialVariantId)materialId))).filter(part -> seen.add(part.m_41720_())).sorted(Comparator.comparing(a -> ForgeRegistries.ITEMS.getKey((Object)a.m_41720_()))).toList();
    }

    protected final void drawString(GuiGraphics gui, String string, int x, float lineNumber, int color, boolean shadow) {
        int y = (int)(lineNumber * 10.0f);
        gui.m_280056_(FONT, string, x, y, color, shadow);
    }

    protected final void drawComponent(GuiGraphics gui, Component component, int x, float lineNumber, int color, boolean shadow) {
        int y = (int)(lineNumber * 10.0f);
        gui.m_280614_(FONT, component, x, y, color, shadow);
    }

    protected final void drawStatComponent(GuiGraphics gui, Component component, float lineNumber) {
        if (!component.m_7360_().isEmpty()) {
            Component sibling = (Component)component.m_7360_().get(0);
            this.drawComponent(gui, (Component)sibling.m_6879_(), FONT.m_92852_((FormattedText)component.m_6879_()), lineNumber, sibling.m_7383_().m_131135_().m_131265_(), true);
        }
        this.drawComponent(gui, (Component)component.m_6879_(), 0, lineNumber, ColorProvider.TEXT, false);
    }

    protected final void drawComponentShadowCentered(GuiGraphics gui, Component component, float lineNumber, int color) {
        this.drawComponent(gui, component, (180 - FONT.m_92852_((FormattedText)component)) / 2, lineNumber, color, true);
    }

    protected final void drawTraits(GuiGraphics gui, List<ModifierEntry> traits, float lineNumber) {
        for (ModifierEntry trait : traits) {
            MutableComponent component = trait.getDisplayName().m_6879_();
            int color = trait.getDisplayName().m_7383_().m_131135_().m_131265_();
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.drawComponent(gui, (Component)component, 180 - FONT.m_92852_((FormattedText)component), f, color, true);
        }
    }

    public final boolean addMaterialTooltip(ITooltipBuilder tooltips, MaterialStatsWrapper wrapper, double mouseX, double mouseY) {
        String key = Util.makeTranslationKey((String)"material", (ResourceLocation)wrapper.getMaterialId());
        int width = FONT.m_92895_(ForgeI18n.getPattern((String)key));
        if (Utils.inBox(mouseX, mouseY, (float)(180 - width) / 2.0f, 0.0f, width)) {
            tooltips.add((FormattedText)Component.m_237115_((String)(key + ".flavor")).m_130940_(ChatFormatting.ITALIC));
            return true;
        }
        return false;
    }

    protected final boolean addStatTooltip(ITooltipBuilder tooltips, IMaterialStats stats, int i, double mouseX, double mouseY, float lineNumber) {
        return this.addStatTooltip(tooltips, stats, i, 0, mouseX, mouseY, lineNumber);
    }

    protected final boolean addStatTooltip(ITooltipBuilder tooltips, IMaterialStats stats, int i, int x, double mouseX, double mouseY, float lineNumber) {
        Component desc;
        assert (stats.getLocalizedInfo().size() == stats.getLocalizedDescriptions().size());
        int width = FONT.m_92852_((FormattedText)((Component)stats.getLocalizedInfo().get(i)).m_6879_());
        if (Utils.inBox(mouseX, mouseY, x, lineNumber * 10.0f, width) && !(desc = (Component)stats.getLocalizedDescriptions().get(i)).equals(Component.m_237119_())) {
            tooltips.add((FormattedText)desc);
            return true;
        }
        return false;
    }

    protected final boolean addTraitTooltip(ITooltipBuilder tooltips, List<ModifierEntry> traits, double mouseX, double mouseY, float lineNumber) {
        for (ModifierEntry trait : traits) {
            String key = Util.makeTranslationKey((String)"modifier", (ResourceLocation)trait.getId());
            int width = FONT.m_92852_((FormattedText)trait.getDisplayName());
            float f = lineNumber;
            lineNumber = f + 1.0f;
            if (!Utils.inBox(mouseX, mouseY, 180 - width, f * 10.0f - 1.0f, width)) continue;
            tooltips.add((FormattedText)Component.m_237115_((String)(key + ".flavor")).m_130940_(ChatFormatting.ITALIC));
            tooltips.add((FormattedText)Component.m_237115_((String)(key + ".description")));
            return true;
        }
        return false;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public RecipeType<MaterialStatsWrapper> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

