/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.client;

import java.util.ArrayList;
import java.util.List;
import me.paypur.tconjei.ColorProvider;
import me.paypur.tconjei.TConJEI;
import me.paypur.tconjei.Utils;
import me.paypur.tconjei.client.ClientConfig;
import me.paypur.tconjei.jei.MaterialStatsWrapper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import slimeknights.tconstruct.tools.item.RepairKitItem;
import slimeknights.tconstruct.tools.stats.SkullStats;

@Mod.EventBusSubscriber(modid="tconjei", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientForgeEventHandler {
    @SubscribeEvent
    public static void onLogin(RecipesUpdatedEvent event) {
        TConJEI.allMaterialsTooltip.clear();
        if (!((Boolean)ClientConfig.ENABLE_TOOLTIP.get()).booleanValue()) {
            return;
        }
        for (MaterialStatsWrapper wrapper : Utils.getMaterialWrappers()) {
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            if (wrapper.hasStats(TConJEI.HARVEST_STAT_IDS)) {
                components.add(Component.m_237115_((String)"tconjei.tooltip.harvest"));
            }
            if (wrapper.hasStats(TConJEI.RANGED_STAT_IDS)) {
                components.add(Component.m_237115_((String)"tconjei.tooltip.ranged"));
            }
            if (wrapper.hasStats(TConJEI.ARMOR_STAT_IDS)) {
                components.add(Component.m_237115_((String)"tconjei.tooltip.armor"));
            }
            if (wrapper.hasStats(List.of(SkullStats.ID))) {
                components.add(Component.m_237115_((String)"tconjei.tooltip.skull"));
            }
            if (components.isEmpty()) continue;
            MutableComponent child = Component.m_237113_((String)" ");
            if (components.size() == 1) {
                child.m_7220_((Component)components.get(0));
            } else {
                int i;
                for (i = 0; i < components.size() - 1; ++i) {
                    child.m_7220_((Component)components.get(i)).m_7220_((Component)Component.m_237115_((String)"tconjei.tooltip.separator"));
                }
                child.m_7220_((Component)Component.m_237115_((String)"tconjei.tooltip.and")).m_7220_((Component)components.get(i));
            }
            child.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"tconjei.tooltip.material")).m_130940_(ChatFormatting.GRAY);
            int tier = wrapper.material().getTier();
            MutableComponent component = Component.m_237110_((String)"tconjei.tooltip.tier", (Object[])new Object[]{tier}).m_130938_(style -> style.m_178520_(ColorProvider.getTierColor(tier).orElse(0xAAAAAA).intValue())).m_7220_((Component)child);
            for (ItemStack stack : wrapper.getInputs()) {
                if (stack.m_41720_() instanceof RepairKitItem) continue;
                TConJEI.allMaterialsTooltip.put(stack.m_41720_(), (Component)component);
            }
        }
    }

    @SubscribeEvent
    public static void onToolTip(ItemTooltipEvent event) {
        if (!((Boolean)ClientConfig.ENABLE_TOOLTIP.get()).booleanValue()) {
            return;
        }
        Item key = event.getItemStack().m_41720_();
        if (TConJEI.allMaterialsTooltip.containsKey(key)) {
            event.getToolTip().add(TConJEI.allMaterialsTooltip.get(key));
        }
    }
}

