/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.message;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class UpdateEffectVisualityEntityMessage {
    private int entityID;
    private int fromEntityID;
    private int potionType;
    private int duration;
    private boolean remove;

    public UpdateEffectVisualityEntityMessage(int entityID, int fromEntityID, int potionType, int duration) {
        this(entityID, fromEntityID, potionType, duration, false);
    }

    public UpdateEffectVisualityEntityMessage(int entityID, int fromEntityID, int potionType, int duration, boolean remove) {
        this.entityID = entityID;
        this.fromEntityID = fromEntityID;
        this.potionType = potionType;
        this.duration = duration;
        this.remove = remove;
    }

    public static UpdateEffectVisualityEntityMessage read(FriendlyByteBuf buf) {
        return new UpdateEffectVisualityEntityMessage(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean());
    }

    public static void write(UpdateEffectVisualityEntityMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityID);
        buf.writeInt(message.fromEntityID);
        buf.writeInt(message.potionType);
        buf.writeInt(message.duration);
        buf.writeBoolean(message.remove);
    }

    public static void handle(UpdateEffectVisualityEntityMessage message, Supplier<NetworkEvent.Context> context) {
        context.get().setPacketHandled(true);
        ServerPlayer playerSided = context.get().getSender();
        if (context.get().getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            playerSided = AlexsCaves.PROXY.getClientSidePlayer();
        }
        if (playerSided != null) {
            Entity entity = playerSided.m_9236_().m_6815_(message.entityID);
            Entity senderEntity = playerSided.m_9236_().m_6815_(message.fromEntityID);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (senderEntity != null && senderEntity.m_20270_((Entity)living) < 32.0f) {
                    MobEffect mobEffect = null;
                    int level = 0;
                    switch (message.potionType) {
                        case 0: {
                            mobEffect = (MobEffect)ACEffectRegistry.IRRADIATED.get();
                            break;
                        }
                        case 1: {
                            mobEffect = (MobEffect)ACEffectRegistry.BUBBLED.get();
                            entity.m_216990_((SoundEvent)ACSoundRegistry.SEA_STAFF_BUBBLE.get());
                            break;
                        }
                        case 2: {
                            mobEffect = (MobEffect)ACEffectRegistry.MAGNETIZING.get();
                            break;
                        }
                        case 3: {
                            mobEffect = (MobEffect)ACEffectRegistry.STUNNED.get();
                            break;
                        }
                        case 4: {
                            mobEffect = (MobEffect)ACEffectRegistry.IRRADIATED.get();
                            level = 4;
                        }
                    }
                    if (mobEffect != null) {
                        if (message.remove) {
                            living.m_6234_(mobEffect);
                        } else {
                            living.m_7292_(new MobEffectInstance(mobEffect, message.duration, level));
                        }
                    }
                }
            }
        }
    }
}

