/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.level.feature.config.FloatingOrbFeatureConfig;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class FloatingOrbFeature
extends Feature<FloatingOrbFeatureConfig> {
    public FloatingOrbFeature(Codec<FloatingOrbFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<FloatingOrbFeatureConfig> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource randomSource = context.m_225041_();
        if (!FloatingOrbFeature.canReplace(level.m_8055_(pos))) {
            return false;
        }
        int minRadius = ((FloatingOrbFeatureConfig)context.m_159778_()).minRadius;
        int radAdd = Math.max(1, ((FloatingOrbFeatureConfig)context.m_159778_()).maxRadius - ((FloatingOrbFeatureConfig)context.m_159778_()).minRadius);
        int radius = minRadius + randomSource.m_188503_(radAdd);
        FloatingOrbFeature.drawOrb(level, pos, randomSource, ((FloatingOrbFeatureConfig)context.m_159778_()).orbBlock, radius + randomSource.m_188503_(2) - 1, radius + randomSource.m_188503_(2) - 1, radius + randomSource.m_188503_(2) - 1);
        return true;
    }

    private static boolean canReplace(BlockState state) {
        return state.m_60795_() || state.m_247087_();
    }

    private static void drawOrb(WorldGenLevel level, BlockPos center, RandomSource random, BlockStateProvider blockState, int radiusX, int radiusY, int radiusZ) {
        double equalRadius = (double)(radiusX + radiusY + radiusZ) / 3.0;
        for (int x = -radiusX; x <= radiusX; ++x) {
            for (int y = -radiusY; y <= radiusY; ++y) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    BlockPos fill = center.m_7918_(x, y, z);
                    if (!(fill.m_203202_((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_()) <= equalRadius * equalRadius + (double)(random.m_188501_() * 2.0f)) || !FloatingOrbFeature.canReplace(level.m_8055_(fill))) continue;
                    level.m_7731_(fill, blockState.m_213972_(random, fill), 3);
                }
            }
        }
    }
}

