/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.item;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.enchantment.ACEnchantmentRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import com.github.alexmodguy.alexscaves.server.message.UpdateEffectVisualityEntityMessage;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class PrimitiveClubItem
extends Item {
    private final Multimap<Attribute, AttributeModifier>[] defaultModifiers = new ImmutableMultimap[4];

    public PrimitiveClubItem(Item.Properties properties) {
        super(properties);
        for (int i = 0; i <= 3; ++i) {
            this.defaultModifiers[i] = this.getStatsForEnchantmentLevel(i);
        }
    }

    private ImmutableMultimap getStatsForEnchantmentLevel(int swiftwoodLevel) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 8.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)Math.min(0.0f, -3.75f + 0.15f * (float)swiftwoodLevel), AttributeModifier.Operation.ADDITION));
        return builder.build();
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity hurtEntity, LivingEntity player) {
        stack.m_41622_(1, player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        if (!hurtEntity.m_9236_().f_46443_) {
            MobEffectInstance instance;
            SoundEvent soundEvent = (SoundEvent)ACSoundRegistry.PRIMITIVE_CLUB_MISS.get();
            if (hurtEntity.m_217043_().m_188501_() < 0.8f && hurtEntity.m_7292_(instance = new MobEffectInstance((MobEffect)ACEffectRegistry.STUNNED.get(), 150 + hurtEntity.m_217043_().m_188503_(150), 0, false, false))) {
                AlexsCaves.sendMSGToAll(new UpdateEffectVisualityEntityMessage(hurtEntity.m_19879_(), player.m_19879_(), 3, instance.m_19557_()));
                soundEvent = (SoundEvent)ACSoundRegistry.PRIMITIVE_CLUB_HIT.get();
                int dazingEdgeLevel = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.DAZING_SWEEP.get());
                if (dazingEdgeLevel > 0) {
                    float f = (float)dazingEdgeLevel + 1.2f;
                    AABB aabb = AABB.m_165882_((Vec3)hurtEntity.m_20182_(), (double)f, (double)f, (double)f);
                    for (Entity entity2 : hurtEntity.m_9236_().m_6249_((Entity)player, aabb, Entity::m_271807_)) {
                        if (entity2.m_7306_((Entity)hurtEntity) || entity2.m_7307_((Entity)player) || !(entity2.m_20270_((Entity)hurtEntity) <= f) || !(entity2 instanceof LivingEntity)) continue;
                        LivingEntity inflict = (LivingEntity)entity2;
                        MobEffectInstance instance2 = new MobEffectInstance((MobEffect)ACEffectRegistry.STUNNED.get(), 80 + hurtEntity.m_217043_().m_188503_(80), 0, false, false);
                        inflict.m_6469_(inflict.m_9236_().m_269111_().m_269333_(player), 1.0f);
                        if (!inflict.m_7292_(instance2)) continue;
                        AlexsCaves.sendMSGToAll(new UpdateEffectVisualityEntityMessage(inflict.m_19879_(), player.m_19879_(), 3, instance2.m_19557_()));
                    }
                }
            }
            player.m_9236_().m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
        }
        return true;
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState state, BlockPos blockPos, LivingEntity livingEntity) {
        if ((double)state.m_60800_((BlockGetter)level, blockPos) != 0.0) {
            itemStack.m_41622_(2, livingEntity, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers[0] : super.m_7167_(equipmentSlot);
    }

    public boolean m_6832_(ItemStack item, ItemStack repairItem) {
        return repairItem.m_150930_((Item)ACItemRegistry.HEAVY_BONE.get()) || super.m_6832_(item, repairItem);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        int swift = stack.getEnchantmentLevel((Enchantment)ACEnchantmentRegistry.SWIFTWOOD.get());
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers[Mth.m_14045_((int)swift, (int)0, (int)3)] : super.getAttributeModifiers(slot, stack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)AlexsCaves.PROXY.getISTERProperties());
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        return (double)player.m_36403_(0.0f) < 0.95 || player.f_20921_ != 0.0f;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_36403_(0.0f) < 1.0f && player.f_20921_ > 0.0f) {
                return true;
            }
            player.f_20913_ = -1;
        }
        return false;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (held && (double)player.m_36403_(0.0f) < 0.95 && player.f_20921_ > 0.0f) {
                --player.f_20913_;
            }
        }
    }
}

