/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.CandicornEntity;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class CandicornMeleeGoal
extends Goal {
    private CandicornEntity candicorn;
    private int chargeCooldown = 0;
    private int chargeTimeout = 0;
    private Vec3 startChargeTargetVec = Vec3.f_82478_;
    private Vec3 startChargeFromVec = Vec3.f_82478_;

    public CandicornMeleeGoal(CandicornEntity candicorn) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.candicorn = candicorn;
    }

    public boolean m_8036_() {
        LivingEntity target = this.candicorn.m_5448_();
        return target != null && target.m_6084_() && !this.candicorn.m_6162_();
    }

    public void m_8041_() {
        this.candicorn.setRunning(false);
        this.candicorn.setCharging(false);
        this.chargeCooldown = 0;
        this.startChargeTargetVec = Vec3.f_82478_;
        this.startChargeFromVec = Vec3.f_82478_;
    }

    public void m_8037_() {
        LivingEntity target;
        if (this.chargeCooldown > 0) {
            --this.chargeCooldown;
        }
        if (this.chargeTimeout > 100) {
            this.chargeTimeout = 0;
            this.candicorn.setCharging(false);
        }
        if ((target = this.candicorn.m_5448_()) != null && target.m_6084_()) {
            double distance = this.candicorn.m_20270_((Entity)target);
            double chargeFromDistance = 15.0;
            double attackDistance = this.candicorn.m_20205_() + target.m_20205_() + 0.5f;
            this.candicorn.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
            if (this.candicorn.getAnimation() == CandicornEntity.ANIMATION_STAB) {
                this.candicorn.m_21573_().m_26573_();
                if (this.candicorn.getAnimationTick() > 8 && this.candicorn.getAnimationTick() <= 12 && target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.candicorn), (float)this.candicorn.m_21051_(Attributes.f_22281_).m_22135_())) {
                    target.m_147240_((double)0.6f, this.candicorn.m_20185_() - target.m_20185_(), this.candicorn.m_20189_() - target.m_20189_());
                }
            } else if (this.candicorn.isCharging()) {
                ++this.chargeTimeout;
                this.candicorn.m_21573_().m_26573_();
                Vec3 sub = this.startChargeTargetVec.m_82546_(this.startChargeFromVec);
                Vec3 delta = sub.m_82541_().m_82490_(0.85);
                this.candicorn.m_20256_(this.candicorn.m_20184_().m_82490_(0.9).m_82549_(delta));
                this.candicorn.setChargeYaw(Mth.m_14177_((float)((float)(Mth.m_14136_((double)sub.f_82481_, (double)sub.f_82479_) * 57.2957763671875) - 90.0f)));
                if ((distance < attackDistance || this.candicorn.m_20238_(this.startChargeTargetVec) < attackDistance * attackDistance) && this.candicorn.getChargeProgress(1.0f) == 1.0f && this.candicorn.m_142582_((Entity)target)) {
                    this.chargeCooldown = 100;
                    this.candicorn.setCharging(false);
                }
                this.candicorn.setRunning(true);
            } else if (distance > attackDistance && distance < chargeFromDistance && this.chargeCooldown <= 0 && !this.candicorn.isCharging() && this.candicorn.m_142582_((Entity)target)) {
                this.candicorn.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                this.candicorn.setCharging(true);
                this.startChargeTargetVec = target.m_20182_();
                this.startChargeFromVec = this.candicorn.m_20182_();
            } else if (distance < attackDistance && this.candicorn.getAnimation() == IAnimatedEntity.NO_ANIMATION && this.candicorn.m_142582_((Entity)target) && !this.candicorn.isCharging()) {
                this.candicorn.setAnimation(CandicornEntity.ANIMATION_STAB);
            } else if (distance > attackDistance) {
                this.candicorn.m_21573_().m_5624_((Entity)target, 1.0);
                this.candicorn.setRunning(true);
            } else {
                this.candicorn.setRunning(false);
            }
        }
    }
}

